/*
** AqDownloadsToolbarDelegate
** 
** CHANGES:
** 0.2  (pozytron) Added "preview" button (disabled for release)
*/

#import "AqDownloadsController.h"
#import "AqDownloadsToolbarDelegate.h"


@implementation AqDownloadsToolbarDelegate

/* Initialization */

    static id instance = nil;
    
    + (id) instance; {
        return instance;
    }

    - (void) awakeFromNib; {
        instance = self;
        [self initItems];
    }
    
    - (void) initItems; 
    {
        [self initSearch];
        [self initDrawer];
        [self initBrowseHost];
        
        id l,p;
        l = NSLocalizedStringFromTable(@"Reveal", @"DownloadsToolbar", @"Reveal action label");
        p = NSLocalizedStringFromTable(@"Reveal in Finder", @"DownloadsToolbar", @"Reveal action palette label");

        item_reveal = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_reveal"];
            [item_reveal setLabel: l];
            [item_reveal setPaletteLabel: p];
            [item_reveal setAction: @selector(revealSelected:)];
            [item_reveal setImage: [NSImage imageNamed: @"reveal"]];

        l = NSLocalizedStringFromTable(@"Remove", @"DownloadsToolbar", @"Remove action label");
        p = NSLocalizedStringFromTable(@"Remove Download", @"DownloadsToolbar", @"Remove action palette label");

        item_cancel = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_cancel"];
            [item_cancel setLabel: l];
            [item_cancel setPaletteLabel: p];
            [item_cancel setAction: @selector(removeSelected:)];
            [item_cancel setImage: [NSImage imageNamed: @"delete"]];

        l = NSLocalizedStringFromTable(@"Retry", @"DownloadsToolbar", @"Retry action label");
        p = NSLocalizedStringFromTable(@"Retry Download", @"DownloadsToolbar", @"Retry action palette label");

        item_retry = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_retry"];
            [item_retry setLabel: l];
            [item_retry setPaletteLabel: p];
            [item_retry setAction: @selector(retrySelected:)];
            [item_retry setImage: [NSImage imageNamed: @"retry"]];

        l = NSLocalizedStringFromTable(@"Preview", @"DownloadsToolbar", @"Preview action label");
        p = NSLocalizedStringFromTable(@"Preview Download", @"DownloadsToolbar", @"Preview action palette label");

        item_preview = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_preview"];
            [item_preview setLabel: l];
            [item_preview setPaletteLabel: p];
            [item_preview setAction: @selector(previewSelected:)];
            [item_preview setImage: [NSImage imageNamed: @"AcqPlayLarge"]];
            
        l = NSLocalizedStringFromTable(@"Sweep", @"DownloadsToolbar", @"Sweep action label");
            
            item_sweep = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_sweep"];
            [item_sweep setLabel: l];
            [item_sweep setPaletteLabel: l];
            [item_sweep setAction: @selector(clearAllComplete:)];
            [item_sweep setImage: [NSImage imageNamed: @"broom"]];
    }
    
    - (id) toolbarIdentifier; {
        return @"AqDownloadsToolbarDelegateA";
    }

    
/* Events */

    - (BOOL) canRetrySelection: (id) theTableView; {
        return [[AqDownloadsController instance] canRetrySelected];
    }

    - (BOOL) canPreviewSelection: (id) theTableView; {
        return [[AqDownloadsController instance] canPreviewSelected];
    }
    
    - (BOOL) canRevealSelection: (id) theTableView; {
        return [theTableView selectedRow] > -1;
    }
    
    - (BOOL) canCancelSelection: (id) theTableView; {
        return [theTableView selectedRow] > -1;
    }
    
    - (BOOL) canSweep: (id) theTableView; {
        return ([AqDownloadsController instance]->complete > 0);
    }
    
    - (void) updateSweepItem; {
        [item_sweep setTarget: ([self canSweep: nil]) ? [AqDownloadsController instance] : nil];
    }
    
    - (void) selectionIsChanging: (id) theTableView; 
    {
        [item_reveal  setTarget: ([self canRevealSelection: theTableView]) ? 
            [AqDownloadsController instance] : nil];
        [item_cancel  setTarget: ([self canCancelSelection: theTableView]) ? 
            [AqDownloadsController instance] : nil];
        [item_retry   setTarget: ([self canRetrySelection: theTableView]) ? 
            [AqDownloadsController instance] : nil];
        [item_preview setTarget: ([self canPreviewSelection: theTableView]) ? 
            [AqDownloadsController instance] : nil];

        [super selectionIsChanging: theTableView];
    }


/* NSToolbar Delegate */

    - (id) toolbarDefaultItemIdentifiers: (id) tb; {
        NSMutableArray* array = [[NSMutableArray alloc] init];
        [array addObjectsFromArray: [NSArray arrayWithObjects:
            @"item_search",
            NSToolbarSeparatorItemIdentifier, 
            @"item_sweep",
            NSToolbarSeparatorItemIdentifier,
            //@"item_preview",
            @"item_retry",
            @"item_reveal",
            @"item_cancel",
            NSToolbarSeparatorItemIdentifier, 
            @"item_browsehost",
            nil]];
        return array;
    }
    
    - (id) toolbarAllowedItemIdentifiers: (id) tb; {
        NSMutableArray* array = [[NSMutableArray alloc] init];
        [array addObjectsFromArray: [NSArray arrayWithObjects:	
            @"item_search",
            @"item_retry",
            //@"item_preview",
            @"item_cancel",
            @"item_sweep",
            @"item_reveal",
            @"item_browsehost",
            @"item_drawer",
            NSToolbarSeparatorItemIdentifier, 
            NSToolbarFlexibleSpaceItemIdentifier, 
            NSToolbarSpaceItemIdentifier,
            nil]];
        return array;
    }

@end