/*
** AqToolbarDelegate
** 
** CHANGES:
** 0.1 (pozytron) Changed some references from "Drawer" to "Sidebar"
*/

#import "AqBrowseHostToolbarView.h"
#import "AqContentViewController.h"
#import "AqDownloadsController.h"
#import "AqDrawerController.h"
#import "AqToolbarDelegate.h"
#import "Profile.h"


@implementation AqToolbarDelegate

/* Initialization */
    
    + (id) instance; {
        /* subclasses provide implementation */
        return nil;
    }
    
    - (void) initItems; {
        /* subclasses provide implementation */
    }

    - (void) initSearch; 
    {
        id l = NSLocalizedStringFromTable(@"Search for Files", @"Toolbar", @"Search field label");
        id t = NSLocalizedStringFromTable(@"Enter keywords to initiate a search", @"Toolbar", @"Search field tooltip");
        
        item_search = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_search"];
            [item_search setLabel: l];
            [item_search setPaletteLabel: l];
            [item_search setToolTip: t];
            [item_search setView: searchView];
            [item_search setMinSize: (NSSize){95,  NSHeight([searchView frame])}];
            [item_search setMaxSize: (NSSize){4000,NSHeight([searchView frame])}];
    }
    
    - (void) initDrawer; 
    {
        id l = NSLocalizedStringFromTable(@"Sidebar", @"Toolbar", @"Sidebar toggle label");
        id p = NSLocalizedStringFromTable(@"Toggle Sidebar", @"Toolbar", @"Sidebar toggle palette label");

        item_drawer = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_drawer"];
            [item_drawer setLabel: l];
            [item_drawer setPaletteLabel: p];
            [item_drawer setTarget: self];
            [item_drawer setAction: @selector(toggleSidebar:)];
            [item_drawer setImage: [NSImage imageNamed: @"AcqToggleSidebar"]];
    }
    
    - (void) initBrowseHost;
    {
        id l = NSLocalizedStringFromTable(@"Browse", @"Toolbar", @"Browse Host button label");
        id p = NSLocalizedStringFromTable(@"Browse Host", @"Toolbar", @"Browse Host button palette label");
            
        item_browsehost = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_browsehost"];
            [item_browsehost setLabel: l];
            [item_browsehost setPaletteLabel: p];
            [item_browsehost setEnabled: NO];
            [item_browsehost setView: [[AqBrowseHostToolbarView alloc] initWithFrame: NSMakeRect(0,0,32,32)]];
            [item_browsehost setMinSize: NSMakeSize(32,32)];
            [item_browsehost setMaxSize: NSMakeSize(32,32)];

            [(AqBrowseHostToolbarView*)[item_browsehost view] setEnabled: NO];
    }

    - (id) toolbarIdentifier; {
        return [self className];
    }
    

#pragma mark -
/* NSToolbar Delegate */

    - (id) toolbar: (id) tb itemForItemIdentifier: (id) ident willBeInsertedIntoToolbar: (BOOL) will; {
        return [self valueForKey: ident];
    }
    
    - (id) toolbarDefaultItemIdentifiers: (id) tb; {
        NSMutableArray* array = [[NSMutableArray alloc] init];
        [array addObjectsFromArray: [NSArray arrayWithObjects:
            @"item_download",
            NSToolbarSeparatorItemIdentifier, 
            @"item_search",
            NSToolbarSeparatorItemIdentifier, 
            @"item_reveal",
            @"item_cancel",
            nil]];
        return array;
    }
    
    - (id) toolbarAllowedItemIdentifiers: (id) tb; {
        NSMutableArray* array = [[NSMutableArray alloc] init];
        [array addObjectsFromArray: [NSArray arrayWithObjects:	
            @"item_search",
            @"item_download",
            @"item_drawer",
            @"item_reveal",
            @"item_cancel",
            @"item_sweep",
            @"item_filter",
            NSToolbarSeparatorItemIdentifier, 
            NSToolbarFlexibleSpaceItemIdentifier, 
            NSToolbarSpaceItemIdentifier,
            nil]];
        return array;
    }


#pragma mark -
/* Enable & Disable */

    - (void) enableQueryViewElements; {
        [item_download setTarget: self];
        [menu_download setTarget: self];
    }

    - (void) disableQueryViewElements; {
        [item_download setTarget: nil];
        [menu_download setTarget: nil];
    }
    
    - (void) enableTransferViewElementsWithTarget: (id) target; {
        [item_reveal setTarget: target];
        [item_sweep  setTarget: target];
        [menu_reveal setTarget: target];
        [menu_open   setTarget: target];
        [menu_cancel setTarget: target];
    }
    
    - (void) disableTransferViewElements; {
        [item_reveal setTarget: nil];
        [menu_reveal setTarget: nil];
        [menu_open   setTarget: nil];
        [menu_cancel setTarget: nil];
    }


#pragma mark -
/* Events */

    /* as sent out by AqContentViewController */
    
    - (void) selectionIsChanging: (id) theTableView; 
    {
        AqBrowseHostToolbarView* bhview = (AqBrowseHostToolbarView*)[item_browsehost view];
        
        if ([[theTableView delegate] canBrowseSelection]) {
            [item_browsehost setEnabled: YES];
            [bhview setEnabled: YES];
        } else {
            [item_browsehost setEnabled: NO];
            [bhview setEnabled: NO];
        }

        [[[theTableView window] toolbar] validateVisibleItems];
    }


#pragma mark -
/* Actions */

    - (void) downloadSelected: (id) sender; {
        [[[AqContentViewController instance] currentDelegate] downloadSelected: self];
    }
    
    - (void) toggleSidebar: (id) sender; {
        [[AqDrawerController instance] toggleSidebar];
    }
    
    - (void) clearCompleted: (id) sender; {
        [[AqDownloadsController instance] clearAllComplete: sender];
    }

    - (void) revealSelected: (id) sender; {
        [[AqDownloadsController instance] revealSelected: self];
    }

    - (void) openSelected: (id) sender; {
        [[AqDownloadsController instance] openSelected: self];
    }

    - (void) removeSelected: (id) sender; {
        [[AqDownloadsController instance] removeSelected: self];
    }
    
@end