#import <Cocoa/Cocoa.h>


@interface AqToolbarDelegate : NSObject 
{
    @public
    id window;
    
    id searchView;
    id filterView;
    
    id menu_download;
    id menu_reveal;
    id menu_open;
    id menu_cancel;
    
    id item_search;
    id item_download;
    id item_drawer;
    id item_reveal;
    id item_filter;
    id item_browsehost;
    id item_sweep;
}

+ (id) instance;
- (void) initItems;

- (void) initSearch;
- (void) initDrawer;
- (void) initBrowseHost;

- (id) toolbarIdentifier;

- (void) selectionIsChanging: (id) theTableView;

- (void) enableQueryViewElements;
- (void) disableQueryViewElements;
- (void) enableTransferViewElementsWithTarget: (id) target;
- (void) disableTransferViewElements;

- (void) downloadSelected: (id) sender;
- (void) toggleSidebar: (id) sender;
- (void) clearCompleted: (id) sender;

- (void) revealSelected: (id) sender;
- (void) openSelected: (id) sender;
- (void) removeSelected: (id) sender;

@end