#import "AqBrowseHostQuery.h"
#import "AqBrowseHostToolbarView.h"
#import "AqContentViewController.h"
#import "AqDrawerController.h"
#import "AqQueryController.h"
#import "AqQueryDataSource.h"
#import "NSMenuExtensions.h"


@implementation AqBrowseHostToolbarView

/* Initialization */

    static NSImage* bh = nil;
    static NSImage* mask = nil;
    static NSImage* arrow = nil;
    static NSImage* imacsmall = nil;
    
    - (id) initWithFrame: (NSRect) theFrame; 
    {
        self = [super initWithFrame: theFrame];
    
        if (!bh) 
        {
            mask = [[NSImage imageNamed: @"imac"] copy];
            [mask setFlipped: YES];
            
            bh = [[NSImage imageNamed: @"imac"] copy];
            [bh setFlipped: YES];
    
            arrow = [[NSImage imageNamed: @"downarrow"] copy];
            [arrow setFlipped: YES];
            
            imacsmall = [[NSImage imageNamed: @"imacsmall"] copy];
            [imacsmall setFlipped: NO];
    
            NSImage* black = [[[NSImage alloc] initWithSize: [mask size]] autorelease];
            [black lockFocus];
                [[NSColor blackColor] set];
                NSRectFill(NSMakeRect(0,0,[black size].width,[black size].height));
            [black unlockFocus];
            
            [mask lockFocus];
            [black drawInRect: NSMakeRect(0,0,[black size].width,[black size].height) fromRect: NSZeroRect operation: NSCompositeSourceIn fraction: 0.5];
            [mask unlockFocus];
        }
    
        [self setPullsDown: YES];
        return self;
    }


/* Drawing */

    - (void) drawRect: (NSRect) rect;
    {
        if (rect.size.width > rect.size.height) {	
            rect.origin.x += (rect.size.width - rect.size.height)/2;
            rect.size.width = rect.size.height;
        }
    
        if ([self isEnabled]) {
    
            [bh drawInRect: rect fromRect: NSZeroRect operation: NSCompositeSourceOver fraction: 1.0];
            [arrow drawAtPoint: (NSPoint){rect.origin.x+rect.size.width-[arrow size].width, rect.origin.y+rect.size.height-[arrow size].height-1} fromRect: NSZeroRect operation: NSCompositeSourceOver fraction: 1.0];
            
            if ([[self cell] isHighlighted]) {
                [mask drawInRect: rect fromRect: NSZeroRect operation: NSCompositeSourceOver fraction: 1.0];
            }
    
        } else {
    
            [bh drawInRect: rect fromRect: NSZeroRect operation: NSCompositeSourceOver fraction: 0.5];
    
        }
    }


/* Menu */

    #define BROWSE NSLocalizedStringFromTable(@"Browse %@", @"QueryResultsContextMenu", @"")
    #define BROWSEALL NSLocalizedStringFromTable(@"Browse All Selected Hosts", @"QueryResultsContextMenu", @"")
    
    + (NSArray*) menuItemsFromArray: (id) theArray; 
    {
        NSMutableArray* result = [[[NSMutableArray alloc] init] autorelease];
        int i, count = [theArray count];
        for (i=0; i<MIN(count,10); i++)
        {
            id theQuery = [theArray objectAtIndex: i];
            NSMenuItem* item = [[[NSMenuItem alloc] initWithTitle: [NSString stringWithFormat: BROWSE, theQuery] action: @selector(browseHost:) keyEquivalent: @""] autorelease];
            [item setTarget: ([AqQC hasQuery: theQuery]) ? nil : self];
            [item setImage: imacsmall];
            [item setRepresentedObject: theQuery];
            [result addObject: item];
        }
        return result;
    }

    + (NSArray*) menuItems; {
        return [AqBrowseHostToolbarView menuItemsFromArray: [[[AqContentViewController instance] currentDelegate] selectedBrowseableHosts]];
    }
    
    - (void) mouseDown: (id) theEvent; {
        if ([self isEnabled]) {
            NSMenu* m = [[[NSMenu alloc] initWithTitle: @""] autorelease];
            [AqBrowseHostToolbarView addBrowseableHostsToMenu: m];
            [self setMenu: m];
        }
        [super mouseDown: theEvent];
    }

    #define BROWSEALL NSLocalizedStringFromTable(@"Browse All Selected Hosts", @"QueryResultsContextMenu", @"")

    + (void) addBrowseableHostsToMenu: (NSMenu*) theMenu; {
        id items = [AqBrowseHostToolbarView menuItems];
        if ([items count]) {
            [theMenu addSeparator];
            BOOL atLeastOneEnabled = [theMenu addItems: items];
            if ([items count] > 1 && atLeastOneEnabled) {
                [theMenu addSeparator];
                NSMenuItem* item = [[[NSMenuItem alloc] initWithTitle: BROWSEALL action: @selector(browseAllHosts:) keyEquivalent: @""] autorelease];
                [item setTarget: [AqBrowseHostToolbarView class]];
                [item setRepresentedObject: items];
                [theMenu addItem: item];
            }
        }
    }


/* Actions */

    #define queryView [AqDrawerController instance]->queryView

    + (id) browseHost: (id) theHost; 
    {	
        if ([theHost isKindOfClass: [NSMenuItem class]]) theHost = [theHost representedObject];

        id newQuery = [[[AqBrowseHostQuery alloc] initWithString: theHost] autorelease];

        [AqQC addQuery: newQuery];
        [queryView noteNumberOfRowsChanged];
        int index = [AqQC indexOfQuery: theHost];
        [queryView scrollRowToVisible: index];
        [newQuery performSelector: @selector(stop) withObject: nil afterDelay: 60];
        
        return [AqQC queryAtIndex: index];
    }

    + (void) browseAllHosts: (NSMenuItem*) theItem; 
    {
        NSArray* hosts = [theItem representedObject];
        int i, count = [hosts count];
        for (i=0; i<count; i++) {
            id item = [hosts objectAtIndex: i];
            if ([item target]) {
                [AqBrowseHostToolbarView browseHost: item];
            }
        }
    }

@end