#import "AqAnonymousToolbarDelegate.h"
#import "AqCoreController.h"


@implementation AqAnonymousToolbarDelegate

/* Initialization */

    static id instance = nil;
    
    + (id) instance; {
        return instance;
    }

    - (void) awakeFromNib; {
        instance = self;
        [self initItems];
    }

    - (id) toolbarIdentifier; {
        return @"AqAnonymousToolbarDelegateA";
    }


/* Toolbar Item Initialization */
    
    - (void) initItems; {
        [self initSearch];
        [self initDrawer];
        [self initBrowseHost];
    }


/* NSToolbar Delegate */

    - (id) toolbarDefaultItemIdentifiers: (id) tb; {
        NSMutableArray* array = [[NSMutableArray alloc] init];
        [array addObjectsFromArray: [NSArray arrayWithObjects:
            @"item_search",
            NSToolbarSeparatorItemIdentifier, 
            @"item_drawer",
            NSToolbarSeparatorItemIdentifier, 
            @"item_browsehost",
            nil]];
        return array;
    }
    
    - (id) toolbarAllowedItemIdentifiers: (id) tb; {
        NSMutableArray* array = [[NSMutableArray alloc] init];
        [array addObjectsFromArray: [NSArray arrayWithObjects:	
            @"item_search",
            @"item_drawer",
            @"item_browsehost",
            NSToolbarSeparatorItemIdentifier, 
            NSToolbarFlexibleSpaceItemIdentifier, 
            NSToolbarSpaceItemIdentifier,
            nil]];
        return array;
    }

@end