/*
 ** AqContentViewController
 ** 
 ** CHANGES:
 ** 0.22 (pozytron) Fixed workaround for toolbar window-dragging bug.
 */

#import "AqAnonymousToolbarDelegate.h"
#import "AqContentViewController.h"
#import "AqDownloadsController.h"
#import "AqDownloadsToolbarDelegate.h"
#import "AqFilterController.h"
#import "AqNetworkController.h"
#import "AqNetworkToolbarDelegate.h"
#import "AqQueryController.h"
#import "AqQueryToolbarDelegate.h"
#import "AqUploadsController.h"
#import "AqUploadsToolbarDelegate.h"
#import "DWCustomizableTableView.h"
#import "DWTableScrollView.h"
#import "DWVersionChecker.h"
#import "NSUserDefaultsExtensions.h"


@implementation AqContentViewController

/* Initialization */

    + (AqContentViewController*) instance; {
        static id instance = nil;
        if (!instance) instance = [[AqContentViewController alloc] init];
        return instance;
    }
    
    - (id) init; 
    {
        [defaults registerDefaults: [NSDictionary dictionaryWithObject: @"125" forKey: @"kAqTopSplitHeight"]];

        int i;
        for (i=0; i<3; i++) 
        {
            id tableView;
            id scrollView;
            
            tableView = [[DWCustomizableTableView alloc] init];
                [tableView setAutoresizesAllColumnsToFit: NO];
            
            scrollView = [[DWTableScrollView alloc] init];
                [scrollView setHasVerticalScroller: YES];
                [scrollView setDocumentView: tableView];

            views[i] = scrollView;
            
            if (i==0) {
                [[AqNetworkController instance] setTableView: tableView];
            } else if (i==1) {
                [[AqDownloadsController instance] setTableView: tableView];
            } else if (i==2) {
                [[AqUploadsController instance] setTableView: tableView];
            }
        }

        return [super init];
    }
    
    - (void) applicationWillTerminate; {
    }


#pragma mark -
/* Current View */

    - (id) currentView; {
        return currentView;
    }
    
    - (id) currentDelegate; {
        if ([currentView respondsToSelector: @selector(documentView)]) {
            return [[currentView documentView] delegate];
        } else {
            return nil;
        }
    }
    
    - (AqToolbarDelegate*) currentToolbarDelegate; {
        return [currentToolbar delegate];
    }


#pragma mark -
/* Show Views */

    - (void) showView: (id) theView inBox: (NSBox*) theBox; 
    {
        

        if (currentView != theView) 
        {
            /* splitview sizes */
            
                if ([theView isKindOfClass: [NSSplitView class]]) {
                    float topSplitHeight = [defaults floatForKey: @"kAqTopSplitHeight"];
                    //NSLog(@"topSplitHeight restore: %f", topSplitHeight);
                    id subviews = [theView subviews];
                    id a = [subviews objectAtIndex: 0];
                    id b = [subviews objectAtIndex: 1];
                    
                    NSRect fa = [a frame];
                    NSRect fb = [b frame];
                    NSRect frame = [theView frame];
                                    
                    fa.size.height = topSplitHeight;
                    fb.size.height = frame.size.height - topSplitHeight - [theView dividerThickness];
                                    
                    [a setFrame: fa];
                    [b setFrame: fb];
                }                
            
            /* content view */
                
                [currentView removeFromSuperview];
                [theBox setContentView: theView];
                
                if ([theView respondsToSelector: @selector(documentView)]) {
                    [[theView documentView] sizeToFit];
                }
                
                currentView = theView;
            
            /* events */
            
                [self stopListening];
                if ([theView respondsToSelector: @selector(documentView)]) {
                    [self listenForNotification: NSTableViewSelectionIsChangingNotification selector: @selector(selectionIsChanging:) object: [theView documentView]];
                    [self listenForNotification: NSTableViewSelectionDidChangeNotification selector: @selector(selectionIsChanging:) object: [theView documentView]];
                }
                
            [[[theBox window] contentView] setNeedsDisplay: YES];
        }
    }
    
    - (void) selectionIsChanging: (id) theNotification; {
        [[currentToolbar delegate] selectionIsChanging: [theNotification object]];
    }


#pragma mark -
/* Toolbars */

    - (void) updateToolbarConfigurationWithDictionary: (id) prototypeDictionary forIdentifier: (id) theIdentifier; 
    {
        id configKey = [NSString stringWithFormat: @"NSToolbar Configuration %@", theIdentifier];
        id configDictionary = [[NSMutableDictionary alloc] initWithDictionary: [defaults objectForKey: configKey]];

        if (prototypeDictionary) {
            id key = @"TB Icon Size Mode";
            [configDictionary setObject: [prototypeDictionary objectForKey: key] forKey: key];
            key = @"TB Display Mode";
            [configDictionary setObject: [prototypeDictionary objectForKey: key] forKey: key];
            key = @"TB Size Mode";
            [configDictionary setObject: [prototypeDictionary objectForKey: key] forKey: key];
            
            [defaults setObject: configDictionary forKey: configKey];
        }
    }

    - (void) setToolbarDelegate: (id) theDelegate forWindow: (id) theWindow; 
    {
        id theIdentifier = [theDelegate toolbarIdentifier];
        id oldToolbar = [theWindow toolbar];
        
        if (![[oldToolbar identifier] isEqual: theIdentifier]) 
        {
            
            /* extract configuration dictionary from previous toolbar */
                
                id oldDictionary = [oldToolbar configurationDictionary];
                [oldToolbar release];
            
            /* tweak configuration settings - ensure consistent size & mode */
                
                [self updateToolbarConfigurationWithDictionary: oldDictionary forIdentifier: theIdentifier];

            /* setup new toolbar */

                id newToolbar = [[NSToolbar alloc] initWithIdentifier: theIdentifier];
                    [newToolbar setDelegate: theDelegate];
                    [newToolbar setAllowsUserCustomization: YES];
                    [newToolbar setAutosavesConfiguration: YES];

            /* set toolbar */
                [currentToolbar release];
                currentToolbar = [newToolbar retain];
                [theWindow setToolbar: newToolbar];
                [newToolbar validateVisibleItems];
                
            /* selection change */
            
                if ([currentView respondsToSelector: @selector(documentView)])
                    [theDelegate selectionIsChanging: [currentView documentView]];
                
            // Workaround to prevent toolbar window-dragging bug.
            // (Workaround disabled in Panther, where it seems to work OK).
                
                if ((NSAppKitVersionNumber) < 703) [theWindow setMovableByWindowBackground:NO];

        }
    }


#pragma mark -
/* Specific Views */

    - (void) showAnonymousView: (id) theView inBox: (id) theBox; {
        [self showView: theView inBox: theBox];
        [self setToolbarDelegate: [AqAnonymousToolbarDelegate instance] forWindow: [theBox window]];
    }

    - (void) showQueryViewAtIndex: (int) index inBox: (id) box; {
        id view = [AqQC viewAtIndex: index];
        if (view != currentView) {
            [self showView: view inBox: box];
            [self setToolbarDelegate: [AqQueryToolbarDelegate instance] forWindow: [box window]];
            
            [[AqFilterController instance] contentViewDidChange];
            [[self currentDelegate] updateCell: nil];
        }
    }
    
    - (void) showNetworkViewInBox: (id) box; {
        if (views[0] != currentView) {
            [self showView: views[0] inBox: box];
            [self setToolbarDelegate: [AqNetworkToolbarDelegate instance] forWindow: [box window]];
        }
    }
    
    - (void) showDownloadsViewInBox: (id) box; {
        if (views[1] != currentView) {
            [self showView: views[1] inBox: box];
            [self setToolbarDelegate: [AqDownloadsToolbarDelegate instance] forWindow: [box window]];
        }
    }
    
    - (void) showUploadsViewInBox: (id) box; {
        if (views[2] != currentView) {
            [self showView: views[2] inBox: box];
            [self setToolbarDelegate: [AqUploadsToolbarDelegate instance] forWindow: [box window]];
        }
    }

@end