#import "AqToolbarDelegate.h"


/*
    AqContentViewController maintains internally the views for the 3 stats view objects and communicates with the AqQueryController to obtain the views for the AqQuery objects.  AqContentViewController talks directly with the window to set the content view.  It also assumes control over the window's toolbar.
*/

@interface AqContentViewController : NSObject 
{
    @public
    id views[3];
    id currentView;
    id currentToolbar;
}

+ (AqContentViewController*) instance;
- (void) applicationWillTerminate;

- (id) currentView;
- (id) currentDelegate;
- (AqToolbarDelegate*) currentToolbarDelegate;

- (void) showView: (id) theView inBox: (id) theBox;

- (void) updateToolbarConfigurationWithDictionary: (id) prototypeDictionary forIdentifier: (id) theIdentifier; 
- (void) setToolbarDelegate: (id) theDelegate forWindow: (id) theWindow; 

- (void) showAnonymousView: (id) theView inBox: (id) theBox;
- (void) showQueryViewAtIndex: (int) index inBox: (id) box;
- (void) showNetworkViewInBox: (id) box;
- (void) showDownloadsViewInBox: (id) box;
- (void) showUploadsViewInBox: (id) box;

@end