/*
** AqUploadsController
** 
** CHANGES:
** 0.2  (pozytron) Added "active", "totalBandwidth" and "totalBandwidthString" methods.
*/

#import "AqCoreController.h"
#import "AqUploadsController.h"
#import "AqUpload.h"


@implementation AqUploadsController

/* Initialization */
    
    + (id) instance; {
        static id instance = nil;
        if (!instance) instance = [[AqUploadsController alloc] init];
        return instance;
    }
    

#pragma mark -
/* Events */

    - (id) representationForInfo: (id) theInfo; {
        return [NSString stringWithFormat: @"%@,%@,%@", 	
            [theInfo objectAtIndex: 1],
            [theInfo objectAtIndex: 2],
            [theInfo objectAtIndex: 3]];
    }

    - (void) addUpload: (id) theInfo; 
    {
        id obj, rep = [self representationForInfo: theInfo];
        if (!(obj = [self objectRepresenting: rep])) 
        {
            obj = [AqUpload uploadWithInfo: theInfo];
            [self addObject: obj representingObject: rep];

            [self updateCell: nil];
            [self statsUpdated];
        }
        //[obj setComplete: NO];
    }

    - (void) removeUpload: (id) theInfo; 
    {
        id rep = [self representationForInfo: theInfo];
        AqUpload* obj = [self objectRepresenting: rep];

        if (!obj) return;

        if ([defaults boolForKey: @"kAqAutoClearUploads"] || [obj->amountTransferred value] == 0) {

            [self removeObject: obj];
            [self statsUpdated];

        } else {
        
            [obj->bandwidth setValue: 0];
            obj->state = 4;	/* Complete */
            [obj setComplete: YES];
            [obj invalidateValues];
            
        }

        [self updateCell: nil];
    }

    - (void) updateUploadStats: (id) theInfo;
    {
        id rep = [self representationForInfo: theInfo];
        AqUpload* obj;
        
        if ((obj = [self objectRepresenting: rep])) {
            [obj updateStats: theInfo];
            [obj invalidateValues];
        }
    }


#pragma mark -
/* Update Cell */

    #define ACTIVE NSLocalizedStringFromTable(@"%i active", @"UploadsCell", @"")
    #define NONE NSLocalizedStringFromTable(@"no uploads", @"UploadsCell", @"")

    - (void) updateCell: (id) sender; 
    {
        id string;
        int i, count = [self count], active = 0;
        
        for (i=0; i<count; i++) {
            AqUpload* upload = [objects objectAtIndex: i];
            if ([upload isActive])
                active++;
        }
        
        if (active) {
            string = [NSString stringWithFormat: ACTIVE, active];
            [[AqDrawerStatsTableView uploadsCell] setPrimaryImage: [NSImage imageNamed:@"AcqUploadGreen"]];
        } else {
            string = NONE;
            [[AqDrawerStatsTableView uploadsCell] setPrimaryImage: [NSImage imageNamed:@"AcqUploadGray"]];
        }
        
        [[AqDrawerStatsTableView uploadsCell] setSecondary: string];
        [AqDrawerStatsTableView redrawUploadsCell];
    }

#pragma mark -

    - (int) active; {
        int i, count = [self count], active = 0;
        
        for (i=0; i<count; i++) {
            AqUpload* upload = [objects objectAtIndex: i];
            if ([upload isActive]) active++;
        }
        return active;
    }

#pragma mark -

    - (int) totalBandwidth; {
        int i, count = [objects count];
        float temp, bandwidth = 0;
        for (i=0; i<count; i++) {
            AqTransfer* o = [objects objectAtIndex: i];
            temp = [[o bandwidth] floatValue];
            bandwidth += temp;
            //NSLog(@"TotalBandwidth(%i): %f", i, temp);
        }
    
        //NSLog(@"TotalBandwidth: %i", bandwidth);
        return (int)bandwidth;
    }

    - (id) totalBandwidthString; {
        return [NSString stringWithFormat:@"%.1f kB/s", (float)[self totalBandwidth] / 1024];
    }
    
@end