/*
** AqUpload
** 
** CHANGES:
** 0.1 (pozytron) Added "AcqLite" useragent 
*/

#import "AqCoreController.h"
#import "AqUpload.h"
#import "DWByteSize.h"
#import "DWCachedString.h"
#import "NSStringExtensions.h"


@implementation AqUpload

/* Initialization */

    + (id) uploadWithInfo: (id) theInfo; {
        return [[[AqUpload alloc] initWithInfo: theInfo] autorelease];
    }
    
    - (id) initWithInfo: (id) theInfo; 
    {
        self = [super init];

        /* alloc */
        
            amountRequested    = [[DWByteSize alloc] init];
            amountTransferred  = [[DWByteSize alloc] init];
            bandwidth          = [[DWByteSize alloc] init];

            [bandwidth setZeroValue: @""];
            [bandwidth setPostfix: @"B/s"];
        
        /* values */
        
            host      = [[theInfo objectAtIndex: 1] retain];
            name      = [[theInfo objectAtIndex: 3] retain];
            userAgent = [[theInfo objectAtIndex: 4] retain];
            state     = [[theInfo objectAtIndex: 5] intValue];
            path      = [[theInfo objectAtIndex: 7] retain];    

            canBrowse = [[theInfo objectAtIndex: 8] intValue] == 1;    
            port      = [[theInfo objectAtIndex: 9] intValue];    

            [amountRequested setValue: [[theInfo objectAtIndex: 6] intValue]];
            
            pName = DWTableStringCreate(name, [DWText normalAttributes]);
            
            NSString* psuedoAcquisition = @"LimeWire(Acquisition)";
            NSString* psuedoAcqLite = @"LimeWire(AcqLite)";
            
            if ([userAgent hasPrefix: psuedoAcquisition]) {
                userAgent = [[NSMutableString alloc] initWithString: userAgent];
                [userAgent replaceCharactersInRange: NSMakeRange(0, [psuedoAcquisition length]) withString: @"Acquisition"];
            }
            
            if ([userAgent hasPrefix: psuedoAcqLite]) {
                userAgent = [[NSMutableString alloc] initWithString: userAgent];
                [userAgent replaceCharactersInRange: NSMakeRange(0, [psuedoAcqLite length]) withString: @"AcqLite"];
            }

        return self;
    }
    
    - (void) dealloc; {
        [userAgent release];
        [host release];
        [path release];
        [super dealloc];
    }
    

#pragma mark -
/* Update */
    
    - (void) updateStats: (id) theInfo;
    {
        

        state = [[theInfo objectAtIndex: 4] intValue];

        int r = [[theInfo objectAtIndex: 5] intValue];
        int t = [[theInfo objectAtIndex: 6] intValue];
        if (r>0) [amountRequested setValue: r];
        if (t>0) [amountTransferred setValue: t];

        [bandwidth setValue: [[theInfo objectAtIndex: 7] floatValue]];
                
        //NSLog(@"%@, %i, %@, %@, %@", name, state, amountRequested, amountTransferred, bandwidth);
    }

    - (void) setComplete: (BOOL) theValue; {
        isComplete = theValue;
    }
        
    - (void) remove; {
        [[AqCoreController instance] writeString: [NSString stringWithFormat: @"cancelUpload|%@|%@\n", host, name]];
    }

   
#pragma mark -
/* User Interface Accessors */

    /*
    - (id) stateAsString; 
    {
        switch (state) 
        {
            case 0:	return @"Connecting";
            case 1:	return @"Freeloader";
            case 2:	return @"Limit Reached";
            case 3:	return @"Uploading";
            case 4:	return @"Complete";
            case 5:	return @"Complete";
            case 6:	return @"Failed";
            case 7:	return @"File not Found";
            case 8:	return @"Browse Host";
            case 9:	return @"Queued";
            default:	return @"";
        }
    }
    */
    
    - (BOOL) isActive; {
        return (state == 3) || [bandwidth value] > 0;
    }

    - (BOOL) isComplete; {
        return ((state == 4) || (state == 5)) && isComplete;
    }
    
    - (NSString*) userAgent; {
        return userAgent;
    }

    - (NSString*) host; {
        return host;
    }
    
    - (id) sName; {
        if (!sName) sName = DWTableStringCreate(userAgent, [DWText normalGrayAttributes]);
        return sName;
    }

    - (id) sBandwidth; {
        if (!sBandwidth) {
            if ([self isComplete])
                sBandwidth = DWTableStringCreate([NSString stringWithFormat: NSLocalizedStringFromTable(@"%@ sent", @"AqTransfer", @""), amountTransferred], [DWText normalGrayAttributes]);
            else
                sBandwidth = DWTableStringCreate([NSString stringWithFormat: NSLocalizedStringFromTable(@"%@/%@", @"AqTransfer", @"eg. '5MB/10MB'"), amountTransferred, amountRequested], [DWText normalGrayAttributes]);
        }
        return sBandwidth;
    }

    - (NSArray*) browseableHosts; {
        if (canBrowse)
            return [NSArray arrayWithObject: [NSString stringWithFormat: @"%@:%i", host, port]];
        else
            return nil;
    }
    
@end