#import "AqProgressCell.h"
#import "AqTransferController(Table).h"
#import "DWMultiLevelCell.h"


@implementation AqTransferController (Table)

    - (float) rowHeight; {
        return 34;
    }

    - (id) columnOrderDefaultsName; {
        return [NSString stringWithFormat: @"%@B", [self className]];
    }

#pragma mark -
    
    int compareColProgress(AqTransfer* a, AqTransfer* b) 
    {
        BOOL ca = [a isComplete];
        BOOL cb = [b isComplete];
        if (ca && !cb) return NSOrderedDescending;
        if (!ca && cb) return NSOrderedAscending;

        BOOL ia = [a isActive];
        BOOL ib = [b isActive];
        if (ia && !ib) return NSOrderedDescending;
        if (!ia && ib) return NSOrderedAscending;
                
        float pa = a->amountTransferred->value / a->amountRequested->value;
        float pb = b->amountTransferred->value / b->amountRequested->value;
        if (pa > pb) return NSOrderedDescending;
        if (pa < pb) return NSOrderedAscending;

        return NSOrderedSame;
    }

    int compareColTransfer(AqTransfer* a, AqTransfer* b) 
    {
        float ba = a->bandwidth->value;
        float bb = b->bandwidth->value;
        if (ba > bb) return NSOrderedDescending;
        if (ba < bb) return NSOrderedAscending;

        BOOL ia = [a isActive];
        BOOL ib = [b isActive];
        if (ia && !ib) return NSOrderedDescending;
        if (!ia && ib) return NSOrderedAscending;

        float ra = a->amountRequested->value;
        float rb = b->amountRequested->value;
        if (ra > rb) return NSOrderedDescending;
        if (ra < rb) return NSOrderedAscending;
            
        return NSOrderedSame;
    }

    int compareColTime(AqTransfer* a, AqTransfer* b) 
    {
        float ta = a->timeRemaining;
        float tb = b->timeRemaining;
        if (ta > tb) return NSOrderedDescending;
        if (ta < tb) return NSOrderedAscending;
            
        return NSOrderedSame;
    }

    int compareColFileName(AqTransfer* a, AqTransfer* b) {
        return [(NSString*)a->name caseInsensitiveCompare: (NSString*)b->name];
    }
    
#pragma mark -
    
    - (void) initTable; 
    {
        id n,s;
        DWTableControllerAttributes attributes;
        
        memset(&attributes, 0, sizeof(DWTableControllerAttributes));
        
        n = NSLocalizedStringFromTable(@"Icon", @"TransferTable", @"Column name");
        attributes.identifier = @"col_icon";
        attributes.name       = n;
        attributes.shortName  = @"";
        attributes.flags      = DWNotSortable | DWDefault | DWIconValue | DWCenterAligned;
        attributes.minWidth   = 32;
        attributes.maxWidth   = 32;
        attributes.sel        = @selector(name);
    
        [self addColumn: attributes];
        memset(&attributes, 0, sizeof(DWTableControllerAttributes));
        
        n = NSLocalizedStringFromTable(@"File Name", @"TransferTable", @"Column name");
        attributes.identifier = @"col_name";
        attributes.name       = n;
        attributes.flags      = DWRequired | DWDefault | DWMultiLevelCellValue | DWSortAscendingFirst;
        attributes.cell       = [[[DWMultiLevelCell alloc] init] autorelease];
        attributes.minWidth   = 120;
        attributes.maxWidth   = 600;
        attributes.primary    = @selector(pName);
        attributes.secondary  = @selector(sName);
        attributes.comparator = compareColFileName;
    
        [self addColumn: attributes];
        memset(&attributes, 0, sizeof(DWTableControllerAttributes));
        
        n = NSLocalizedStringFromTable(@"Transfer", @"TransferTable", @"Column name");
        attributes.identifier = @"col_bandwidth";
        attributes.name       = n;
        attributes.flags      = DWDefault | DWCenterAligned | DWMultiLevelCellValue;
        attributes.cell       = [[[DWMultiLevelCell alloc] init] autorelease];
        attributes.minWidth   = 100;
        attributes.maxWidth   = 100;
        attributes.primary    = @selector(pBandwidth);
        attributes.secondary  = @selector(sBandwidth);
        attributes.comparator = compareColTransfer;
    
        [self addColumn: attributes];
        memset(&attributes, 0, sizeof(DWTableControllerAttributes));
        
        n = NSLocalizedStringFromTable(@"Progress", @"TransferTable", @"Column name");
        attributes.identifier = @"col_progress";
        attributes.name       = n;
        attributes.flags      = DWDefault | DWFloatSorted | DWCenterAligned | DWTableCellValue;
        attributes.cell       = [[[AqProgressCell alloc] init] autorelease];
        attributes.minWidth   = 80;
        attributes.maxWidth   = 80;
        attributes.comparator = compareColProgress;
    
        [self addColumn: attributes];
        memset(&attributes, 0, sizeof(DWTableControllerAttributes));
        
        n = NSLocalizedStringFromTable(@"Time Remaining", @"TransferTable", @"Column name");
        s = NSLocalizedStringFromTable(@"Time", @"TransferTable", @"Column name");
        attributes.identifier = @"col_time";
        attributes.name       = n;
        attributes.shortName  = s;
        attributes.flags      = DWDefault | DWCenterAligned | DWMultiLevelCellValue;
        attributes.cell       = [[[DWMultiLevelCell alloc] init] autorelease];
        attributes.minWidth   = 80;
        attributes.maxWidth   = 80;
        attributes.primary    = @selector(pTime);
        attributes.secondary  = @selector(sTime);
        attributes.comparator = compareColTime;
    
        [self addColumn: attributes];
    }

@end