/*
** AqTransfer
** 
** CHANGES:
** 0.2  (pozytron) Added percentComplete utility method and isWaiting placeholder method.
*/

#import "AqDownload.h"
#import "AqTransfer.h"
#import "DWCachedString.h"


@implementation AqTransfer

/* Initialization */
    
    - (id) copyWithZone: (id) zone; {
        return [self retain];
    }

    - (void) dealloc; 
    {
        [name release];
        [localIdentifier release];
        
        [bandwidth release];
        [amountRequested release];
        [amountTransferred release];
        
        [pName release];
        [sName release];
        [pBandwidth release];
        [sBandwidth release];
        [pTime release];
        
        [super dealloc];
    }
    

#pragma mark -
/* Time Conversion */

    static id HOURS = nil;
    static id MINUTES = nil;
    static id SECONDS = nil;
    static id ONEHOUR = nil;
    static id ONEMINUTE = nil;
    static id ONESECOND = nil;

    + (NSString*) stringFromTimeInterval: (NSTimeInterval) theInterval;
    {
        if (!HOURS) {
            HOURS = [NSLocalizedStringFromTable(@"%i hours", @"AqTransfer", @"Time Format") retain];
            MINUTES = [NSLocalizedStringFromTable(@"%i minutes", @"AqTransfer", @"Time Format") retain];
            SECONDS = [NSLocalizedStringFromTable(@"%i sec", @"AqTransfer", @"Time Format") retain];
            ONEHOUR = [NSLocalizedStringFromTable(@"1 hour", @"AqTransfer", @"Time Format") retain];
            ONEMINUTE = [NSLocalizedStringFromTable(@"1 minute", @"AqTransfer", @"Time Format") retain];
            ONESECOND = [NSLocalizedStringFromTable(@"1 sec", @"AqTransfer", @"Time Format") retain];
        }

        int seconds, minutes, hours, days, interval;
        interval = (int) theInterval;
        if (interval < 0) interval = -1 * interval;
        
        if (interval < 1) return @"";
        
        seconds = minutes = hours = days = 0;
        
        if (interval >= 0)     seconds =  interval         % 60;
        if (interval >= 60)    minutes = (interval / 60)   % 60;
        if (interval >= 3600)  hours   = (interval / 3600) % 24;
        if (interval >= 86400) days    =  interval / 86400;

        if (hours > 0) {
            if (hours == 1)   return ONEHOUR;
            else              return [NSString stringWithFormat: HOURS, hours, minutes];
        } else if (minutes > 0) {
            if (minutes == 1) return ONEMINUTE;
            else              return [NSString stringWithFormat: MINUTES, minutes, seconds];
        } else {
            if (seconds == 1) return ONESECOND;
            else     	      return [NSString stringWithFormat: SECONDS, seconds];
        }
    }


#pragma mark -
/* API */

    - (BOOL) isActive; {
        return NO;
    }

    - (BOOL) isComplete; {
        return NO;
    }
    
    - (BOOL) isCorrupt; {
        return NO;
    }
    
    - (BOOL) isOffline; {
        return NO;
    }
    
    - (BOOL) isWaiting; {
        return NO;
    }

    - (void) invalidateValues;
    {
        if ([self isKindOfClass: [AqDownload class]]) {
            [sName release];
            sName = nil;
        }
        
        [pBandwidth release];
        pBandwidth = nil;
        
        [sBandwidth release];
        sBandwidth = nil;
        
        [pTime release];
        pTime = nil;
        
        if ([self isActive] && ![self isComplete] && bandwidth->value)
            timeRemaining = (amountRequested->value-amountTransferred->value)/bandwidth->value;
        else
            timeRemaining = 0;
    }

    
#pragma mark -
/* User Interface Accessors */

    - (id) name; {
        return name;
    }

    - (id) bandwidth; {
        return bandwidth;
    }

    - (id) path; {
        return path;
    }

    - (id) pathExtension; {
        return [[[self path] pathExtension] lowercaseString];
    }
    
    - (id) pName; {
        return pName;
    }
    
    - (id) pBandwidth; {
        if (!pBandwidth && bandwidth->value) {
            pBandwidth = DWTableStringCreate([bandwidth description], [DWText normalAttributes]);
        }
        return pBandwidth;
    }
    
    - (id) sBandwidth; {
        /* subclasses provide implementation */
        return nil;
    }

    - (id) pTime; {
        if (!pTime && timeRemaining > 0) {
            pTime = DWTableStringCreateCached([AqTransfer stringFromTimeInterval: timeRemaining], [DWText normalAttributes]);
        }
        return pTime;
    }

    - (id) sTime; {
        static id REMAINING = nil;
        if (!REMAINING) REMAINING = DWTableStringCreate(NSLocalizedStringFromTable(@"remaining", @"AqTransfer", @""), [DWText normalGrayAttributes]);;

        if (timeRemaining > 0) return REMAINING;
        else return nil;
    }
    
    - (double) percentComplete; {
        return 100 * (amountTransferred->value / amountRequested->value);
    }


#pragma mark -
/* Update */

    - (void) updateStats: (id) theInfo; {
    }

@end