#import "AqInfoObject.h"
#import "DWByteSize.h"
#import "DWCachedString.h"
#import "DWTableString.h"
#import "DWText.h"


@interface AqTransfer : AqInfoObject
{
    @public
    int state;				
    id localIdentifier;
    
    NSString* name;				
    NSString* path;
    
    DWByteSize* bandwidth;
    DWByteSize* amountRequested;
    DWByteSize* amountTransferred;
    
    NSTimeInterval timeRemaining;
    
    DWTableString* pName;
    DWTableString* sName;

    DWTableString* pBandwidth;
    DWTableString* sBandwidth;

    DWTableString* pTime;
}

- (BOOL) isActive;
- (BOOL) isComplete;
- (BOOL) isCorrupt;
- (BOOL) isOffline;
- (BOOL) isWaiting;

- (id) pName;
- (id) pBandwidth;
- (id) sBandwidth;
- (id) bandwidth;
- (id) path;
- (id) pathExtension;

- (double) percentComplete;

- (void) updateStats: (id) theInfo;

@end