/*
** AqNetworkController
** 
** CHANGES:
** 0.2  (pozytron) Added StatusBar related methods, modified oneSecondTimer
*/

#import "AqApplicationController.h"
#import "AqCoreController.h"
#import "AqNetworkController.h"
#import "AqNetworkController(Table).h"
#import "AqDrawerController.h"


@implementation AqNetworkController

/* Initialization */
    
    + (id) instance; {
        static id instance = nil;
        if (!instance) instance = [[AqNetworkController alloc] init];
        return instance;
    }

    - (id) init; 
    {
        self = [super init];
        
        /* alloc */
            
            ultrapeers = [[NSMutableSet alloc] init];
            leaves     = [[NSMutableSet alloc] init];
            peers      = [[NSMutableSet alloc] init];
        
            [self initTable];
            
        /* events */
            
            [self repeatingTimerWithTimeInterval: 1 selector: @selector(oneSecondTimer:)];
            
        return self;
    }


#pragma mark -
/* Events */
    
    /* oneSecondTimer pulses and updates the time interval on all connections */
    
    - (void) oneSecondTimer: (id) sender; {
        int i, count = [objects count];
        for (i=0; i<count; i++) {
            AqConnection* c = [objects objectAtIndex: i];
            [c->timeConnected incrementByOneSecond];
        }
        
        // This is also where we redraw the status
        [AqDrawerController redrawStatusBar];
        if ([defaults boolForKey: @"AcqProgressInDock"]) [AqApplicationController updateDockIcon];
    }

    #define PEERSLEAVES NSLocalizedStringFromTable(@"%i peers, %i leaves", @"NetworkCell", @"")
    #define NEGOTIATING NSLocalizedStringFromTable(@"%i active, %i negotiating", @"NetworkCell", @"")
    #define ACTIVE NSLocalizedStringFromTable(@"%i active", @"NetworkCell", @"")

    - (void) updateCell: (id) sender;
    {
        id string;
        id imageName;
        
        int u = [ultrapeers count];
        int l = [leaves count];
        int p = [peers count];
        int n = [self negotiatingCount];
         
        int t = u + l + p;
        
        /*id theObj;
        NSEnumerator    *enumerator = [ultrapeers objectEnumerator];
        
        while ((theObj = [enumerator nextObject]))  {
            NSLog([theObj count]);
        }*/
        
        if (l > 0) {
            string = [NSString stringWithFormat: PEERSLEAVES, t-l, l];
            imageName = @"AcqGreenLight";
        } else if (n > 0) {
            string = [NSString stringWithFormat: NEGOTIATING, t, n];
            imageName = @"AcqYellowLight";
        } else {
            string = [NSString stringWithFormat: ACTIVE, t];
            imageName = @"AcqGreenLight";
        }
        if (!t) imageName = @"AcqRedLight";

        [[AqDrawerStatsTableView networkCell] setPrimaryImage: [NSImage imageNamed: imageName]];
        [[AqDrawerStatsTableView networkCell] setSecondary: string];
        [AqDrawerStatsTableView redrawNetworkCell];
    }
    
    - (void) connectionInitialized: (id) theInfo; 
    {
        id rep = [theInfo objectAtIndex: 1];
        id obj = [[[AqConnection alloc] initWithInfo: theInfo] autorelease];
        
        [self addObject: obj representingObject: rep];

        if ([obj isUltrapeer]) [ultrapeers addObject: rep];
        if ([obj isLeaf])      [leaves addObject: rep];
        if ([obj isPeer])      [peers addObject: rep];
        
        [self updateCell: nil];
        [tableView noteNumberOfRowsChanged];
    }
    
    - (void) connectionClosed: (id) theInfo; 
    {
        id obj, rep = [theInfo objectAtIndex: 1];
        
        [ultrapeers removeObject: rep];
        [leaves     removeObject: rep];
        [peers      removeObject: rep];

        if ((obj = [self objectRepresenting: rep])) 
        {
            [self removeObject: obj];

            [tableView noteNumberOfRowsChanged];
            [self updateCell: nil];
        }
    }
    
    - (void) updateConnectionStats: (id) theInfo;
    {
        id rep = [theInfo objectAtIndex: 1];
        AqConnection* obj;
        
        if ((obj = [self objectRepresenting: rep])) {
            [obj->horizonFiles setValue: [[theInfo objectAtIndex: 3] doubleValue]];
        }

        negotiatingCount = [[theInfo objectAtIndex: 4] intValue];
    }
    

#pragma mark -
/* API */

    - (void) removeAllObjects; {
        [ultrapeers removeAllObjects];
        [leaves     removeAllObjects];
        [peers      removeAllObjects];
        [super      removeAllObjects];
    }

    - (int) activeCount; {
        return [objects count];
    }
    
    - (int) negotiatingCount; {
        return negotiatingCount;
    }
    
    - (int) fileCount; {
        int i, count = [objects count], files = 0;
        for (i=0; i<count; i++) {
            AqConnection* c = [objects objectAtIndex: i];
            //NSLog(@"FileCount(%i): %i", i, [c horizonFiles]);
            files += [c horizonFiles];
        }
    
        //NSLog(@"FileCount: %i", files);
        return files;
    }

    + (int) totalPeers; {
        return [[AqNetworkController instance] activeCount];
    }

    + (int) totalFiles; {
        return [[AqNetworkController instance] fileCount];
    }
   
@end