#import "AqNetworkController(Table).h"


@implementation AqNetworkController (Table)

/* Comparator Functions (TableView Sorting) */

    int compareColFiles(AqConnection* a, AqConnection* b) {
        if (a->horizonFiles->value > b->horizonFiles->value) return NSOrderedDescending;
        if (a->horizonFiles->value < b->horizonFiles->value) return NSOrderedAscending;
        return NSOrderedSame;
    }

    int compareColUptime(AqConnection* a, AqConnection* b) {
        if (a->timeConnected->value > b->timeConnected->value) return NSOrderedDescending;
        if (a->timeConnected->value < b->timeConnected->value) return NSOrderedAscending;
        return NSOrderedSame;
    }

/* Table */

    - (void) initTable; 
    {
        DWTableControllerAttributes attributes;
        id n,s;
        
        memset(&attributes, 0, sizeof(DWTableControllerAttributes));
        
        n = NSLocalizedStringFromTable(@"Host", @"NetworkTable", @"Host column name");
        attributes.identifier = @"col_host";
        attributes.name       = n;
        attributes.flags      = DWRequired | DWDefault | DWTableStringValue;
        attributes.minWidth   = 115;
        attributes.maxWidth   = 115;
        attributes.sel        = @selector(hostAsTableString);
        attributes.sortSel    = @selector(host);

        [self addColumn: attributes];
        memset(&attributes, 0, sizeof(DWTableControllerAttributes));
                    
        n = NSLocalizedStringFromTable(@"Agent", @"NetworkTable", @"Agent column name");
        attributes.identifier = @"col_agent";
        attributes.name       = n;
        attributes.flags      = DWDefault | DWTableStringValue | DWSortAscendingFirst | DWStringSorted;
        attributes.minWidth   = 120;
        attributes.maxWidth   = 300;
        attributes.sel        = @selector(userAgentAsTableString);
        attributes.sortSel    = @selector(userAgent);

        [self addColumn: attributes];
        memset(&attributes, 0, sizeof(DWTableControllerAttributes));
        
        n = NSLocalizedStringFromTable(@"Uptime", @"NetworkTable", @"Uptime column name");
        attributes.identifier = @"col_time";
        attributes.name       = n;
        attributes.flags      = DWCenterAligned | DWImageAccessor | DWDefault;
        attributes.minWidth   = 75;
        attributes.maxWidth   = 75;
        attributes.sel        = @selector(timeConnected);
        attributes.comparator = compareColUptime;

        [self addColumn: attributes];
        memset(&attributes, 0, sizeof(DWTableControllerAttributes));

        n = NSLocalizedStringFromTable(@"Connection Type", @"NetworkTable", @"Type column name");
        s = NSLocalizedStringFromTable(@"Type", @"NetworkTable", @"Type column short name");
        attributes.identifier = @"col_type";
        attributes.name       = n;
        attributes.shortName  = s;
        attributes.flags      = DWCenterAligned | DWDefault | DWCachedImageValue;
        attributes.minWidth   = 65;
        attributes.maxWidth   = 65;
        attributes.sel        = @selector(typeAsImage);
        attributes.sortSel    = @selector(type);

        [self addColumn: attributes];
        memset(&attributes, 0, sizeof(DWTableControllerAttributes));
        
        n = NSLocalizedStringFromTable(@"Files on Horizon", @"NetworkTable", @"Files column name");
        s = NSLocalizedStringFromTable(@"Files", @"NetworkTable", @"Files column short name");
        attributes.identifier = @"col_horizonfiles";
        attributes.name       = n;
        attributes.shortName  = s;
        attributes.flags      = DWCenterAligned | DWTableStringValue;
        attributes.minWidth   = 60;
        attributes.maxWidth   = 60;
        attributes.sel        = @selector(horizonFilesTS);
        attributes.comparator = compareColFiles;

        [self addColumn: attributes];
    }

@end