#import "AqBrowseHostToolbarView.h"
#import "AqNetworkController(Actions).h"


@implementation AqNetworkController (Actions)

/* Contextual Menu */

    #define REMOVE NSLocalizedStringFromTable(@"Remove", @"NetworkContextMenu", @"")
    #define REMOVEALL NSLocalizedStringFromTable(@"Remove All", @"NetworkContextMenu", @"")

    - (id) menuForEvent: (NSEvent*) theEvent; 
    {
        NSMenu *m, *m1;
        NSMenuItem *i;

        m  = [[[NSMenu alloc] initWithTitle: @"nil"] autorelease];
        m1 = [[[NSMenu alloc] initWithTitle: @"nil"] autorelease];
    
        int row = [tableView rowAtPoint: [theEvent locationInView: tableView]];
        if (row >= 0 && ![tableView isRowSelected: row])
            [tableView selectRow: row byExtendingSelection: NO];
        
        BOOL atLeastOneRowSelected = ([tableView selectedRow] >= 0);

        [[tableView window] makeFirstResponder: tableView];
        
        /* remove */
        
            if (atLeastOneRowSelected) {
                i = [[[NSMenuItem alloc] initWithTitle: REMOVE action: @selector(removeSelected:) keyEquivalent: @""] autorelease];
                [i setTarget: self];
                [m addItem: i];
            }

            i = [[[NSMenuItem alloc] initWithTitle: REMOVEALL action: @selector(removeAll:) keyEquivalent: @""] autorelease];
            [i setTarget: self];
            [m addItem: i];

        /* browse host */
            
            [AqBrowseHostToolbarView addBrowseableHostsToMenu: m];
            
        return m;
    }

@end