/*
** AqConnection
** 
** CHANGES:
** 0.1  (pozytron) Changed a function to display AcqLite clients correctly.
** 0.2  (pozytron) Added horizonFiles method
*/

#import "AqConnection.h"
#import "AqCoreController.h"
#import "DWCachedString.h"
#import "DWTableString.h"
#import "DWText.h"
#import "NSStringExtensions.h"

#define psuedoAcquisition @"LimeWire(Acquisition)"
#define psuedoAcqLite @"LimeWire(AcqLite)"

@implementation AqConnection

/* Initialization */

    - (id) initWithInfo: (NSArray*) theInfo;
    {
        

        /* extract info */
        
            host      = [[theInfo objectAtIndex: 1] retain];
            port      = [[theInfo objectAtIndex: 2] intValue];
            userAgent = [[theInfo objectAtIndex: 3] retain];
            type 	  = [[theInfo objectAtIndex: 4] retain];
        
        /* replace "LimeWire(Acquisition)" with "Acquisition" */
            
            if ([userAgent hasPrefix: psuedoAcquisition]) {
                userAgent = [[NSMutableString alloc] initWithString: userAgent];
                [userAgent replaceCharactersInRange: NSMakeRange(0, [psuedoAcquisition length]) withString: @"Acquisition"];
            }
        
        /* replace "LimeWire(AcqLite)" with "AcqLite" */
            
            if ([userAgent hasPrefix: psuedoAcqLite]) {
                userAgent = [[NSMutableString alloc] initWithString: userAgent];
                [userAgent replaceCharactersInRange: NSMakeRange(0, [psuedoAcqLite length]) withString: @"AcqLite"];
            }
        
        /* allocate */
        
            timeConnected = [[DWTimeInterval alloc] init];
            
            horizonFiles = [[DWSISize alloc] init];
              [horizonFiles setZeroValue: nil];
              [horizonFiles setMinimumMagnitude: 0];

        return [super init];
    }
    
    - (void) dealloc; {
        [host release];			[hostAsTableString release];
        [userAgent release];		[userAgentAsTableString release];
        [type release];			[typeAsImage release];
        [horizonFiles release];
        [super dealloc];
    }


#pragma mark -
/* Close */

    - (void) remove; {
        [AqCoreController writeString: [NSString stringWithFormat: @"closeConnection|%@\n", host]];
    }

    - (BOOL) isUltrapeer; {	
        return [type isEqual: @"Ultrapeer"];
    }
    
    - (BOOL) isLeaf; {
        return [type isEqual: @"Leaf"];
    }
    
    - (BOOL) isPeer; {
        return [type isEqual: @"Peer"];
    }
    
    - (NSArray*) browseableHosts; {
        return [NSArray arrayWithObject: [NSString stringWithFormat: @"%@:%i", host, port]];
    }
    

#pragma mark -
/* User Interface Accessors */
    
    - (id) host; {
        return host;
    }
    
    - (id) hostAsTableString; {
        if (!hostAsTableString)
            hostAsTableString = [[DWTableString alloc] initWithString: host attributes: [DWText smallTextAttributes]];
        return hostAsTableString;
    }
    
    - (id) userAgent; {
        return userAgent;
    }
    
    - (id) userAgentAsTableString; {
        if (!userAgentAsTableString)
            userAgentAsTableString = [[DWTableString alloc] initWithString: userAgent attributes: [DWText smallTextAttributes]];
        return userAgentAsTableString;
    }

    - (id) type; {
        return type;
    }
    
    - (id) typeAsImage; {
        if (!typeAsImage)
            typeAsImage = [[DWCachedString alloc] initWithString: type attributes: [DWText smallTextAttributes]];
        return typeAsImage;
    }

    - (DWTimeInterval*) timeConnected; {
        return timeConnected;
    }

    - (id) horizonFilesTS; {
        return [horizonFiles tableString];
    }

    - (int) horizonFiles; {
        return (int)([horizonFiles value]);
    }


#pragma mark -
/* Equality */

    - (BOOL) isEqual: (id) obj; {
        return [host isEqual: obj];
    }
    
    - (unsigned) hash; {
        return [host hash];
    }

@end