#import "AqInfoObject.h"
#import "DWByteSize.h"
#import "DWSISize.h"
#import "DWTimeInterval.h"


@interface AqConnection : AqInfoObject 
{
    @public
    id host;			
    id userAgent;		
    id type;			
    int port;
    
    id hostAsTableString;
    id userAgentAsTableString;
    NSImage* typeAsImage;

    DWTimeInterval* timeConnected;
    DWSISize* horizonFiles;
}

- (id) initWithInfo: (NSArray*) theInfo;

- (BOOL) isUltrapeer;
- (BOOL) isLeaf;
- (BOOL) isPeer;

/* UI */

- (id) host;			
- (id) hostAsTableString;

- (id) userAgent;		
- (id) userAgentAsTableString;

- (int) horizonFiles;		
- (id) horizonFilesTS;

- (id) type;			
- (NSImage*) typeAsImage;

@end