#import "AqTransferController.h"


@interface AqDownloadsController : AqTransferController 
{
    @public

    int active;
    int complete;
    int waiting;
    
    BOOL hasUnviewedCompleteFiles;
}

+ (AqDownloadsController*) instance;

- (void) addDownload: (id) theInfo; 
- (void) removeDownload: (id) theInfo; 
- (void) updateDownloadStats: (id) theInfo;

- (BOOL) canOpenSelectedIniTunes;

- (BOOL) canRetrySelected;
- (BOOL) canPreviewSelected;
- (void) retrySelected: (id) sender;

- (BOOL) canRequerySelected;
- (void) requerySelected: (id) sender;

- (void) recalculateCounts; 

- (int) active;
- (int) complete;
- (int) waiting;
- (int) total;

- (AqTransfer*) downloadAtIndex:(int)theIndex;
- (int) totalBandwidth;
- (id) totalBandwidthString;

- (NSMenu*) menuWithDownloads: (int)selectedItem;
+ (void) cancelStatusDownload: (id) sender;
+ (void) openStatusDownload: (id) sender;
+ (void) showStatusDownload: (id) sender;

@end