#import "AqInfoController.h"
#import "AqInfoObject.h"
#import "NSMutableDictionaryExtensions.h"


@implementation AqInfoController

/* Initialization */
    
    - (id) init; {
        representedObjects = [[NSMutableDictionary alloc] init];
        shouldSaveSortOrder = YES;
        return [super init];
    }


#pragma mark -
/* Add & Remove */
    
    - (void) addObject: (id) obj representingObject: (id) rep; {
        [self saveSelectedObjects];
          [self addTableObject: obj];
          [representedObjects setObject: obj forKey: rep];
        [self sort];
        [self restoreSelectedObjects];
    }

    - (void) removeObject: (id) obj; {
        [self saveSelectedObjects];
            [objects removeObject: obj];
            [representedObjects removeObject: obj];
        [self restoreSelectedObjects];
    }
    
    - (id) objectRepresenting: (id) rep; {
        return [representedObjects objectForKey: rep];
    }
    
    - (void) removeAllObjects; {
        [super removeAllObjects];
        [representedObjects removeAllObjects];
        [self updateCell: nil];
    }
    
    - (void) statsUpdated; {
        [self saveSelectedObjects];
            [self sort];
        [self restoreSelectedObjects];
        [tableView noteNumberOfRowsChanged];
        [self updateCell: nil];
    }

    
#pragma mark -
/* Event Handlers */
    
    - (void) updateCell: (id) sender; { 
    }


#pragma mark -
/* nextKeyView chain */

    - (NSView*) nextValidKeyView; {
        return [AqDrawerController instance]->statsView;
    }

    - (NSView*) previousValidKeyView; {
        return [AqDrawerController instance]->statsView;
    }
    
    - (void) leftKeyPressed; {
        [[tableView window] makeFirstResponder: [self previousValidKeyView]];
    }
    
    - (void) rightKeyPressed; {
        [[tableView window] makeFirstResponder: [self nextValidKeyView]];
    }

    - (void) deleteKeyPressed; {
        [self removeSelected: nil];
    }


#pragma mark -
/* Actions */

    - (void) removeSelected: (id) sender; {
        id o, e = [[self selectedObjects] objectEnumerator];
        while ((o = [e nextObject])) {
            [o remove];
            [self removeObject: o];
        }
        [tableView deselectAll: self];
        [tableView noteNumberOfRowsChanged];
        [self updateCell: self];
    }

    - (void) removeAll: (id) sender; {
        [tableView selectAll: nil];
        [self removeSelected: nil];
    }
    
@end