/*
** AqIPFilter
** 
** CHANGES:
** 0.1 (pozytron) Changed support folder to "AcqLite"
*/

#import "AqIPFilter.h"
#import "NSFileManagerExtensions.h"


@implementation AqIPFilter

/* Initialization */
    
    #define kAqIPFilterPath [@"~/Application Support/AcqLite/BannedIPs/" stringByExpandingTildeInPath]
    #define fm [NSFileManager defaultManager]
    
    + (id) instance; {
        static id instance = nil;
        if (!instance) instance = [[AqIPFilter alloc] init];
        return instance;
    }
    
    - (id) init; {
        bannedIPs = [[NSMutableSet alloc] init];
        return self;
    }
    
    
/* Termination */

    - (void) applicationWillTerminate; {
        if ([bannedIPs count]) {
            [fm createDirectoryAtPathRecursive: kAqIPFilterPath];
        }
    }


/* API */

    - (void) banIP: (id) theIP; {
        [bannedIPs addObject: theIP];
        NSLog(@"%@", bannedIPs);
    }
    
    - (BOOL) isBanned: (id) theIP; {
        return [bannedIPs containsObject: theIP];
    }

@end