#import "AqContentViewController.h"
#import "AqFilterController.h"
#import "AqQueryDataSource.h"
#import "NSUserDefaultsExtensions.h"


@implementation AqFilterController

/* Initialization */
    
    #define AqFilterControllerCurrentFilterIndex @"AqFilterControllerCurrentFilterIndex"
    
    static id instance = nil;
    
    + (id) instance; {
        return instance;
    }
    
    - (void) awakeFromNib; 
    {
        instance = self;
        
        /* set up the view */

            [filterBox setTitlePosition: NSNoTitle];
            [filterBox setBorderType: NSNoBorder];
            [filterBox setContentViewMargins: NSZeroSize];
            
        /* keyword field */
        
            [self listenForNotification: NSControlTextDidChangeNotification selector: @selector(keywordFieldTextDidChange:) object: keywordField];
            [self listenForNotification: NSControlTextDidEndEditingNotification selector: @selector(keywordFieldTextDidChange:) object: keywordField];
            
        /* select the last filter shown */

            int defaultIndex = [defaults integerForKey: AqFilterControllerCurrentFilterIndex];
            if (!(defaultIndex < kAqTotalFilters)) {
                defaultIndex = 0;
            }
    
            [self setCurrentFilterIndex: defaultIndex];
            
            /* stupid menu separators, screwing everything up */

            if (defaultIndex > 3) defaultIndex += 2;
            else if (defaultIndex > 2) defaultIndex += 1;
            if (defaultIndex < [filterMenu numberOfItems]) [filterMenu selectItemAtIndex: defaultIndex];
    }
    

#pragma mark -
/* Terminate */

    - (void) applicationWillTerminate; {
        [defaults setInteger: currentFilterIndex forKey: AqFilterControllerCurrentFilterIndex];
    }
    

#pragma mark -
/* Set Filter */

    #define queryDataSource [[AqContentViewController instance] currentDelegate]
    
    /* contentViewDidChange is invoked by the AqContentViewController whenever the frontmost query changes, so that the visible filter values can be updated.  This is necessary since each query maintains it's own set of filters */
    
    - (void) contentViewDidChange; 
    {
        /* weird initialization situation */
        if (![filterBox contentView]) {
            [self setCurrentFilterIndex: currentFilterIndex];
        }
        
        [[queryDataSource filterForIndex: currentFilterIndex] synchronizeViewWithCurrentState];
        
        #if 0
        NSLog(@"contentViewDidChange: %@", queryDataSource);
        #endif
    }

    - (void) setCurrentFilterIndex: (int) aqFilterIndex; 
    {
        id theFilter = [queryDataSource filterForIndex: aqFilterIndex];
        currentFilterIndex = aqFilterIndex;
        
        id filterView = [theFilter filterView];
        [(NSBox*)filterBox setContentView: filterView];
        
        [filterView setTarget: self];
        [filterView setAction: @selector(filterChangedState:)];
        
        [theFilter synchronizeViewWithCurrentState];
    }


#pragma mark -
/* Action */

    - (void) keywordFieldTextDidChange: (id) notification; {
        //NSLog(@"%@", notification);
        if (currentFilterIndex == kAqKeywordFilter)
            [self filterChangedState: keywordField];
    }
    
    - (void) filterChangedState: (id) filterView; 
    {
        if (![queryDataSource isKindOfClass: [AqQueryDataSource class]]) return;

        AqFilter* currentFilter = [queryDataSource filterForIndex: currentFilterIndex];

        if ([currentFilter filterView] != filterView) return;
        
        AqFilterStateChange change = [currentFilter changeState: filterView];

        switch (change) {
            case kAqFilterNoChange:
                /* do nothing */
                break;

            case kAqFilterTightening:
                [queryDataSource tightenFilter: currentFilterIndex];
                break;

            case kAqFilterRelaxing:
                [queryDataSource relaxFilter: currentFilterIndex];
                break;
                
            case kAqFilterUnknown:
                [queryDataSource reevaluateAllFilters: currentFilterIndex];
                break;
        }
    
        [queryDataSource updateCell: nil];
    
        #if 0
        NSLog(@"filterChangedState: %@", filterView);
        #endif
    }
    

#pragma mark -
/* show... */
    
    - (void) showReliability: (id) sender; {
        [self setCurrentFilterIndex: kAqReliabilityFilter];
    }
    
    - (void) showBitrate: (id) sender; {
        [self setCurrentFilterIndex: kAqBitrateFilter];
    }
    
    - (void) showSize: (id) sender; {
        [self setCurrentFilterIndex: kAqSizeFilter];
    }
    
    - (void) showMedia: (id) sender; {
    /*
        [self setCurrentFilterIndex: kAqMediaFilter];
    */
    }
    
    - (void) showKeyword: (id) sender; {
        [self setCurrentFilterIndex: kAqKeywordFilter];
    }
    
    - (void) showSpeed: (id) sender; {
        [self setCurrentFilterIndex: kAqSpeedFilter];
    }
    
    - (void) showHosts: (id) sender; {
        [self setCurrentFilterIndex: kAqHostFilter];
    }


/* Filter Control */

    /*
    - (void) resetAllFilters: (id) sender; {
        NSLog(@"%@", [filterMenu selectedItem]);
    }
    
    - (void) editDefaultFilters: (id) sender; {
        NSLog(@"%@", [filterMenu selectedItem]);
    }
    */

@end