#import "AqRemoteFile.h"

#define kAqReliabilityFilter	0
#define kAqBitrateFilter	1
#define kAqSizeFilter		2
#define kAqKeywordFilter	3
#define kAqSpeedFilter		4
#define kAqHostFilter		5

#define kAqTotalFilters		6


typedef enum {
    kAqFilterTightening,	/* elements will only be discarded */
    kAqFilterRelaxing,		/* only  previously hidden elements will return */
    kAqFilterUnknown,		/* elements may be added and removed */
    kAqFilterNoChange		/* no change will happen */
} AqFilterStateChange;


@interface AqFilter : NSObject 
{
    @public
    int       iState;
    float     fState;
    NSString* sState;
}

- (id) filterView;
- (AqFilterStateChange) changeState: (id) filterView;
- (void) synchronizeViewWithCurrentState;
- (NSString*) currentStateDescription;				/* eg. '4 stars' */
- (BOOL(*)(AqFilter*, AqRemoteFile*)) filterFunction;
- (BOOL) passesFilter: (AqRemoteFile*) theFile;

@end


@interface AqReliabilityFilter : AqFilter
{
}
@end


@interface AqBitrateFilter : AqFilter
{
}
@end


@interface AqSizeFilter : AqFilter
{
}
@end


/*
typedef enum {
    kAqMediaFilterAll    = 0,
    kAqMediaFilterMusic  = 2,
    kAqMediaFilterVideo  = 3,
    kAqMediaFilterImages = 4,
    kAqMediaFilterFiles  = 5
} AqMediaFilterState;

@interface AqMediaFilter : AqFilter
{
}
@end
*/


@interface AqKeywordFilter : AqFilter
{
    NSMutableArray* positive;
    NSMutableArray* negative;
}
@end


@interface AqSpeedFilter : AqFilter
{
}
@end


@interface AqHostFilter : AqFilter
{
}
@end