#import "DWSplitView.h"
#import "NSUserDefaultsExtensions.h"


@implementation DWSplitView

    - (id) initWithFrame: (NSRect) theFrame; 
    {
        self = [super initWithFrame: theFrame];
        [self setDelegate: self];

        [self setPostsFrameChangedNotifications: NO];
        [self setPostsBoundsChangedNotifications: NO];

        return self;
    }
    
/* ensure that the splitview cannot be resized all the way to the bottom of the screen. 100 pixels of the bottom view will always be visible */
    
    - (float) splitView: (id) theView constrainSplitPosition: (float) thePosition ofSubviewAt: (int) theOffset;
    {
        float result = thePosition;
    
        if (theOffset == 0) {
            if ([self frame].size.height < (thePosition + 100)) 
                result = [self frame].size.height - 100;
            [defaults setFloat: result forKey: @"kAqTopSplitHeight"];
        }
        
        return result;
    }
    
/* keep the size of the top view constant during window resizing */
    
    - (void) resizeSubviewsWithOldSize: (NSSize) old;
    {
        id subviews = [self subviews];
        id a = [subviews objectAtIndex: 0];
        id b = [subviews objectAtIndex: 1];
        
        NSRect fa = [a frame];
        NSRect fb = [b frame];
        NSRect frame = [self frame];
        
        fa.size.width = fb.size.width = frame.size.width;
        fb.size.height += frame.size.height - old.height;
    
        [a setFrame: fa];
        [b setFrame: fb];
        
        [self adjustSubviews];
    }
    
@end