#import "AqRemoteFile.h"


/* MetaNode */

    @interface AqMetaNode : NSObject 
    {
        @public
        id files[2];
        id sfiles[2];
        id nodes;
        
        int dwColorIndex;
        id image;
        id primary;
        id secondary;
        id name;
        id metaView;
    }
    
    - (id) initWithName: (id) theName;
    - (void) handleFile: (AqRemoteFile*) theFile isVisible: (BOOL) visible;
    - (void) sort;

    - (id) nodes;
    - (id) files;
    - (id) hiddenFiles;
    - (id) name;

    - (int) hiddenCount;
    - (int) visibleCount;
    - (int) totalCount;
    
    @end


/* Root */

    @interface AqRootNode : AqMetaNode
    {
        id allTypesNode;
        id musicNode;
        id imageNode;
        id videoNode;
        id documentsNode;
        id filesNode;
    }
    
    - (id) allTypesNode;
    
    @end
    
    
    @interface AqAllTypesNode : AqMetaNode
    {
        id parent;
        id musicNode;
    }
    
    - (id) initWithName: (id) theName parent: (id) theParent;
    
    @end


/* Music */

    @interface AqSortingNode : AqMetaNode
    {
        id allFilesNode;
        id unknownNode;
        id nameToNode;
    }
    @end


    @interface AqMusicNode : AqSortingNode
    {	
    }
    @end
    
    
    @interface AqArtistNode : AqSortingNode
    {
    }
    @end
    
    
    @interface AqAllArtistsNode : AqArtistNode
    {
    }
    @end


    @interface AqAlbumNode : AqMetaNode
    {
    }
    @end
    
    
/* Misc */

    @interface AqImageNode : AqMetaNode
    {
    }
    @end
    
    
    @interface AqVideoNode : AqMetaNode
    {
    }
    @end
    

    @interface AqDocumentsNode : AqMetaNode
    {
    }
    @end

    
    @interface AqFilesNode : AqMetaNode
    {
    }
    @end