#import "AqMetaNode(Drawing).h"
#import "DWTableString.h"


@implementation AqMetaNode (Drawing)

/* Images */

    + (id) resizedImage: (id) theImage; {
        NSSize size = NSMakeSize(16,16);
        id img = [[NSImage alloc] initWithSize: size];
        [img lockFocus];
            [theImage setFlipped: YES];
            [theImage drawInRect: (NSRect){{0,0},size} fromRect: NSZeroRect operation: NSCompositeSourceOver fraction: 1.0];
        [img unlockFocus];
        return img;
    }
    
    + (id) musicImage; {
        static id img = nil;
        if (!img) img = [self resizedImage: [NSImage imageNamed: @"music"]];
        return img;
    }
    
    + (id) imageImage; {
        static id img = nil;
        if (!img) img = [self resizedImage: [NSImage imageNamed: @"pictures"]];
        return img;
    }
    
    + (id) videoImage; {
        static id img = nil;
        if (!img) img = [self resizedImage: [NSImage imageNamed: @"movies"]];
        return img;
    }

    + (id) documentsImage; {
        static id img = nil;
        if (!img) img = [self resizedImage: [NSImage imageNamed: @"document"]];
        return img;
    }
    
    + (id) filesImage; {
        static id img = nil;
        if (!img) img = [self resizedImage: [NSImage imageNamed: @"docs"]];
        return img;
    }
    
    + (id) artistImage; {
        static id img = nil;
        if (!img) img = [self resizedImage: [[NSImage imageNamed: @"registration"] copy]];
        return img;
    }
    
    + (id) albumImage; {
        static id img = nil;
        if (!img) img = [self resizedImage: [NSImage imageNamed: @"album"]];
        return img;
    }


/* Attributes */

    + (id) primaryAttributes; {
        static id attributes = nil;
        if (!attributes)
            attributes = [[NSDictionary alloc] initWithObjectsAndKeys: [NSFont systemFontOfSize: 11], NSFontAttributeName, [NSColor blackColor], NSForegroundColorAttributeName, nil];
        return attributes;
    }

    + (id) secondaryAttributes; {
        static id attributes = nil;
        if (!attributes)
            attributes = [[NSDictionary alloc] initWithObjectsAndKeys: [NSFont systemFontOfSize: 10], NSFontAttributeName, [NSColor grayColor], NSForegroundColorAttributeName, nil];
        return attributes;
    }

    + (id) secondaryBlueAttributes; {
        static id attributes = nil;
        if (!attributes)
            attributes = [[NSDictionary alloc] initWithObjectsAndKeys: [NSFont boldSystemFontOfSize: 10], NSFontAttributeName, [NSColor colorWithCalibratedRed: 0.313726 green: 0.654902 blue: 0.988235 alpha: 1.0], NSForegroundColorAttributeName, nil];
        return attributes;
    }


/* Mutators */

    - (void) setImage: (id) theImage; {
        image = theImage;
    }

    - (void) setPrimary: (id) theText; {
        [primary release];
        primary = DWTableStringCreate(theText, [AqMetaNode primaryAttributes]);
    }

    - (void) setSecondary: (id) theText; {
        [secondary release];
        secondary = DWTableStringCreateCached(theText, [AqMetaNode secondaryAttributes]);
        [secondary setStyle: DWCollapseNone];
    }


/* Drawing */

    #define kAqQueryCellRightMargin 8.0f
    #define kAqQueryCellLeftMargin 20.0f

    - (void) drawWithFrame: (NSRect) frame; 
    {
        if (!primary && name) {
            [self setPrimary: name];
        }
        
        if (!secondary && [self totalCount]) {
            if ([self hiddenCount]) 
                [self setSecondary: [NSString stringWithFormat: @"%i/%i", [self visibleCount], [self totalCount]]];
            else 
                [self setSecondary: [NSString stringWithFormat: @"%i", [self totalCount]]];
        }

        /* image */
        
            [image drawAtPoint: (NSPoint){frame.origin.x+1, frame.origin.y+1} fromRect: NSZeroRect operation: NSCompositeSourceOver fraction: 1.0];

        /* text - points */
            
            float sWidth = 0;
            if (secondary) sWidth = [secondary totalWidth] + 2.0f * kAqQueryCellRightMargin;
                        
            NSPoint primaryPoint = (NSPoint){
                frame.origin.x + kAqQueryCellLeftMargin,
                frame.origin.y + 2
            };
            NSPoint secondaryPoint = (NSPoint){
                frame.origin.x + frame.size.width - [secondary totalWidth] - kAqQueryCellRightMargin,
                frame.origin.y + 3
            };

        /* text - draw */
            
            id theString;
            NSRect theRect;
           
            /* secondary */
                
                theString = secondary;
                theRect = frame;
                theRect.origin = secondaryPoint;

                if (dwColorIndex == kDWColorAlternateIndex) {
                    [theString setAlternateColor: [DWColor whiteColor]];
                    theString = [theString alternateString];
                }
    
                [theString drawInRect: theRect centered: NO];
            
            /* primary */
            
                if (secondary) [primary setStyle: DWCollapseRight];
                else [primary setStyle: DWCollapseNone];
            
                theRect = frame;
                theRect.origin = primaryPoint;
                theRect.size.width -= (primaryPoint.x + sWidth);
                theString = primary;
    
                if (dwColorIndex == kDWColorAlternateIndex) {
                    [theString setAlternateColor: [DWColor whiteColor]];
                    theString = [theString alternateString];
                }
    
                [theString drawInRect: theRect centered: NO];
    }

@end