/*
** AqMetaNode(Actions)
** 
** CHANGES:
** 0.1 (pozytron) Added Link to All Music Group search, changed Amazon.com link
*/

#import "AqMetaNode(Actions).h"
#import "NSMenuExtensions.h"


@implementation AqMetaNode (ContextMenu)

    - (id) menuForEvent: (id) theEvent; {
        return nil;
    }

@end


@implementation AqSortingNode (ContextMenu)

    #define AMAZON NSLocalizedStringFromTable(@"Search Amazon.com", @"MetaBrowserContextMenu", @"")
    #define ECHOCLOUD NSLocalizedStringFromTable(@"Find Similar Artists", @"MetaBrowserContextMenu", @"")
    #define ALLMUSIC NSLocalizedStringFromTable(@"Search allmusic.com", @"MetaBrowserContextMenu", @"")
    
    - (id) menuForEvent: (NSEvent*) theEvent; {
        if ([self isKindOfClass: [AqAllArtistsNode class]]) return nil;
        if ([self isKindOfClass: [AqMusicNode class]]) return nil;
        NSMenu* m = [[[NSMenu alloc] initWithTitle: @""] autorelease];
        [m addItemWithTitle: name action: nil target: nil];
        [m addSeparator];
        [m addItemWithTitle: AMAZON action: @selector(amazon:) target: self];
        [m addItemWithTitle: ECHOCLOUD action: @selector(echocloud:) target: self];
        [m addItemWithTitle: ALLMUSIC action: @selector(allmusic:) target: self];
        return m;
    }
    
    - (id) urlFriendlyName; {
        return [[name componentsSeparatedByString: @" "] componentsJoinedByString: @"+"];
    }
    
    - (void) amazon: (id) sender; {
        [[NSWorkspace sharedWorkspace] openURL: [NSURL URLWithString: [NSString stringWithFormat: @"http://www.amazon.com/exec/obidos/external-search?mode=blended&keyword=%@", [self urlFriendlyName]]]];
    }
    
    - (void) echocloud: (id) sender; {
        [[NSWorkspace sharedWorkspace] openURL: [NSURL URLWithString: [NSString stringWithFormat: @"http://echocloud.net/index.php?searchword=%@&option=asearch&nrows=20&cur=0&stype=2&order=0", [self urlFriendlyName]]]];
    }
    
    - (void) allmusic: (id) sender; {
        [[NSWorkspace sharedWorkspace] openURL: [NSURL URLWithString: [NSString stringWithFormat: @"http://www.allmusic.com/cg/amg.dll?P=amg&sql=%@&opt1=1", [self urlFriendlyName]]]];
    }

@end