#import "AqMediaType.h"
#import "AqQueryResponse.h"
#import "DWCachedImage.h"
#import "AqTableObject.h"


/*
    This class exists since there needs to be a way to associate identical remote files on different servers as a single entity.  This is necessary for swarmed downloading and for treatment as a single entity by the UI.
    
    Ideally, 'equality' of two remote files is established by SHA1 hash.  However, since this is not yet widely adopted, we will, for the interim, presume that files with identical names and identical sizes are identical.  This should be amended when SHA1 hashes are more commonplace.
*/

@interface AqRemoteFile : AqTableObject 
{
    @public
    id responses;
    int count;
    
    id pathExtension;
    AqMediaType mediaType;
    DWCachedImage* icon;
    
    id name;			
    id nameAsTableString;
    
    id albumAsTableString;

    id nData;

    id host;			
    id hostAsTableString;
    int hAddress[4];
    
    float rating;		id ratingAsNumber;
    unsigned speed;             id speedAsByteSize;

    unsigned size;              id sizeAsByteSize;
    unsigned bitrate;		id bitrateAsByteSize;
    id length;			id lengthAsImage;

    id sha1;
    NSString* album;	
    NSString* albumlc;
    NSString* artist;
    NSString* artistlc;
    id year;
    id title;
}

- (void) addResponse: (AqQueryResponse*) theResponse;
- (unsigned) count;
- (id) responses;

- (void) download;

- (id) nameAsData;
- (float) rating;		
- (id) sha1;
- (AqMediaType) mediaType;

@end