#import "AqQueryResponse.h"
#import "AqCoreController.h"


@implementation AqQueryResponse

/* Initialization */

    - (id) initWithInfo: (id) theInfo;
    {
        static id urnCache = nil;
        static id nameCache = nil;
        
        if (!urnCache) {
            urnCache = [[NSMutableSet alloc] init];
            nameCache = [[NSMutableSet alloc] init];
        }
        
        self = [super init];
        
        host    = [[theInfo objectAtIndex: 2] retain];
        port    = [[theInfo objectAtIndex: 3] intValue];
        rating  = [[theInfo objectAtIndex: 5] intValue];
        speed   = [[theInfo objectAtIndex: 6] intValue];
        index   = [[theInfo objectAtIndex: 7] intValue];
        size    = [[theInfo objectAtIndex: 8] intValue];
        name    = [[theInfo objectAtIndex: 9] retain];
        sha1    = [[theInfo objectAtIndex: 10] retain];
        bitrate = [[theInfo objectAtIndex: 11] intValue];
        localIndex = [[theInfo objectAtIndex: 12] intValue];
        canBrowseHost = [[theInfo objectAtIndex: 13] intValue];
        artist  = [[theInfo objectAtIndex: 14] retain];
        album   = [[theInfo objectAtIndex: 15] retain];
        year    = [[theInfo objectAtIndex: 16] retain];
        title   = [[theInfo objectAtIndex: 17] retain];
            
        /* fix the results */
        
            if ([sha1 isEqual: @"null"]) {
                [sha1 release];
                sha1 = nil;
            }
    
            if ([artist isEqual: @""]) {
                [artist release];
                artist = nil;
            }

            if ([album isEqual: @""]) {
                [album release];
                album = nil;
            }

            if ([year isEqual: @""]) {
                [year release];
                year = nil;
            }

            if ([title isEqual: @""]) {
                [title release];
                title = nil;
            }
    
        /* the following peculiarity is done to speed up isEqual, which is called very frequently.  We do this so we can test for pointer equality and be done with it */
        
            if (sha1) {
                id s;
                if ((s = [urnCache member: sha1])) {
                    [sha1 release];
                    sha1 = s;
                    //NSLog(@"s +");
                } else {
                    [urnCache addObject: sha1];
                    //NSLog(@"s -");
                }
            }
    
            if (name) {
                id n;
                if ((n = [nameCache member: name])) {
                    [name release];
                    name = n;
                    //NSLog(@"n +");
                } else {
                    [nameCache addObject: name];
                    //NSLog(@"n -");
                }
            }
        
        return self;
    }

    - (void) dealloc; 
    {
        //NSLog(@"AqQueryResponse: dealloc");

        //[name release];
        //[sha1 release];
        [host release];
        [title release];
        [artist release];
        [album release];
        [year release];
        
        [super dealloc];
    }


/* Copying */
    
    - (id) copyWithZone: (id) zone; {
        return [self retain];
    }
    
    - (void) encodeWithCoder: (id) theCoder; {
    }

    - (id) initWithCoder: (id) theCoder; {
        return nil;
    }


/* Descriptors */
    
    /* this is used to uniquely tag a particular file on a particular host, in order that future identical responses are ignored */
    - (id) uniqueDescriptor; {
        return [NSString stringWithFormat: @"%@,%i,%i,%@", host, port, index, sha1]; 
    }

    /* this is used to uniquely tag a file on the network, for the purposes of grouping identical files */
    - (id) uniqueFileDescriptor; {
        if (sha1) return sha1;
        else return [NSString stringWithFormat: @"%@,%i", [name lowercaseString], size]; 
    }

@end