#import "AqFilter.h"
#import "AqQuery.h"
#import "AqRemoteFile.h"
#import "AqStarCell.h"
#import "AqTableController.h"
#import "DWUtil.h"


@interface AqQueryDataSource : AqTableController 
{
    @public
    
    AqQuery* query;
    BOOL hasUnviewedFiles;
    AqRootNode* rootNode;
    AqMetaNode* currentNode;
    
    /* filters */
    
    AqFilter* filters[kAqTotalFilters];
    BOOL filterIsActive[kAqTotalFilters];

    /* AqRemoteFiles */
    
    id newFiles;
    NSTimer* timer;
}

- (id) initWithQuery: (AqQuery*) theQuery;

- (void) updateFile: (AqRemoteFile*) theFile;

- (id) rootNode;
- (void) setCurrentNode: (AqMetaNode*) theNode;

- (AqFilter*) filterForIndex: (int) aqFilterIndex;
- (BOOL) objectPassesAllFilters: (AqRemoteFile*) theFile;
- (void) tightenFilter: (int) aqFilterIndex;
- (void) relaxFilter: (int) aqFilterIndex;
- (void) reevaluateAllFilters: (int) aqFilterIndex;

- (void) updateCell: (id) sender;

@end