/*
** AqQueryDataSource(Table)
** 
** CHANGES:
** 0.1  (pozytron) Added "Album" column (disabled)
*/

#import "AqBrowseHostQuery.h"
#import "AqQueryDataSource(Table).h"


@implementation AqQueryDataSource (Table)

/* Defaults */

    - (id) columnOrderDefaultsName; {
        return [query className];
    }

    - (id) columnSortDefaultsName; {
        return [query className];
    }

/* Comparator Functions */

    int compareColHost(AqRemoteFile* a, AqRemoteFile* b)
    {
        int ac = a->count; 
        int bc = b->count;

        if (ac > bc) return NSOrderedDescending;
        if (ac < bc) return NSOrderedAscending;
        if (ac != 1) return NSOrderedSame;

        int* ah = a->hAddress;
        int* bh = b->hAddress;

        if (ah[0] > bh[0]) return NSOrderedDescending;
        if (ah[0] < bh[0]) return NSOrderedAscending;

        if (ah[1] > bh[1]) return NSOrderedDescending;
        if (ah[1] < bh[1]) return NSOrderedAscending;

        if (ah[2] > bh[2]) return NSOrderedDescending;
        if (ah[2] < bh[2]) return NSOrderedAscending;

        if (ah[3] > bh[3]) return NSOrderedDescending;
        if (ah[3] < bh[3]) return NSOrderedAscending;
        
        return NSOrderedSame;
    }

    int compareColQuality(AqRemoteFile* a, AqRemoteFile* b) {
        int va = a->rating;
        int vb = b->rating;
        if (va > vb) return NSOrderedDescending;
        if (va < vb) return NSOrderedAscending;

        return compareColHost(a,b);
    }

    int compareColSize(AqRemoteFile* a, AqRemoteFile* b) {
        int va = a->size;
        int vb = b->size;
        if (va > vb) return NSOrderedDescending;
        if (va < vb) return NSOrderedAscending;
        return NSOrderedSame;
    }

    int compareColSpeed(AqRemoteFile* a, AqRemoteFile* b) {
        int va = a->speed;
        int vb = b->speed;
        if (va > vb) return NSOrderedDescending;
        if (va < vb) return NSOrderedAscending;
        return NSOrderedSame;
    }

    int compareColBitrate(AqRemoteFile* a, AqRemoteFile* b) {
        int va = a->bitrate;
        int vb = b->bitrate;
        if (va > vb) return NSOrderedDescending;
        if (va < vb) return NSOrderedAscending;
        return NSOrderedSame;
    }

    int compareColName(AqRemoteFile* a, AqRemoteFile* b) {
        id av = (a->title) ? a->title : a->name;
        id bv = (b->title) ? b->title : b->name;
        return [av caseInsensitiveCompare: bv];
    }
    
    int compareColIcon(AqRemoteFile* a, AqRemoteFile* b) {
        return [(NSString*)a->pathExtension caseInsensitiveCompare: (NSString*)b->pathExtension];
    }

    int compareColAlbum(AqRemoteFile* a, AqRemoteFile* b) {
        id av = a->album;
        id bv = b->album;
        return [av caseInsensitiveCompare: bv];
    }
    
/* Columns */
            
    - (void) initTable;
    {
        id n, s;
        
        DWTableControllerAttributes attributes;
        memset(&attributes, 0, sizeof(DWTableControllerAttributes));
        
        n = NSLocalizedStringFromTable(@"Icon", @"QueryResultsTable", @"Column name");
        attributes.identifier = @"col_icon";
        attributes.name       = n;
        attributes.shortName  = @"";
        attributes.flags      = DWDefault | DWCachedImageValue | DWCenterAligned | DWSortAscendingFirst;
        attributes.minWidth   = 17;
        attributes.maxWidth   = 17;
        attributes.sel        = @selector(icon);
        attributes.comparator = compareColIcon;

        [self addColumn: attributes];
        memset(&attributes, 0, sizeof(DWTableControllerAttributes));
        
        n = NSLocalizedStringFromTable(@"File Name", @"QueryResultsTable", @"Column name");
        attributes.identifier = @"col_name";
        attributes.name       = n;
        attributes.flags      = DWRequired | DWDefault | DWTableStringValue | DWSortAscendingFirst;
        attributes.minWidth   = 65;
        attributes.maxWidth   = 750;
        attributes.sel        = @selector(nameAsTableString);
        attributes.comparator = compareColName;
        
        [self addColumn: attributes];
        
        if (![query isKindOfClass: [AqBrowseHostQuery class]])
        {
            memset(&attributes, 0, sizeof(DWTableControllerAttributes));
            
            n = NSLocalizedStringFromTable(@"Host", @"QueryResultsTable", @"Column name");
            attributes.identifier = @"col_host";
            attributes.name       = n;
            attributes.flags      = DWCenterAligned | DWDefault | DWTableStringValue;
            attributes.minWidth   = 90;
            attributes.maxWidth   = 90;
            attributes.sel        = @selector(hostAsTableString);
            attributes.comparator = compareColHost;
    
            [self addColumn: attributes];
        }

        memset(&attributes, 0, sizeof(DWTableControllerAttributes));
        
        n = NSLocalizedStringFromTable(@"Reliability of Host", @"QueryResultsTable", @"Column name");
        s = NSLocalizedStringFromTable(@"Reliability", @"QueryResultsTable", @"Short column name");
        attributes.identifier = @"col_quality";
        attributes.name       = n;
        attributes.shortName  = s;
        attributes.cell       = [[[AqStarCell alloc] init] autorelease];
        attributes.flags      = DWDefault | DWTableCellValue | DWNoIndicators | DWCenterAligned;
        attributes.minWidth   = 58;
        attributes.maxWidth   = 58;
        attributes.comparator = compareColQuality;
        
        [self addColumn: attributes];

        if (![query isKindOfClass: [AqBrowseHostQuery class]])
        {
            memset(&attributes, 0, sizeof(DWTableControllerAttributes));
            
            n = NSLocalizedStringFromTable(@"Speed of Host", @"QueryResultsTable", @"Column name");
            s = NSLocalizedStringFromTable(@"Speed", @"QueryResultsTable", @"Short column name");
            attributes.identifier = @"col_speed";
            attributes.name       = n;
            attributes.shortName  = s;
            attributes.flags      = DWCenterAligned | DWImageAccessor;
            attributes.minWidth   = 60;
            attributes.maxWidth   = 60;
            attributes.sel        = @selector(speedAsByteSize);
            attributes.comparator = compareColSpeed;
    
            [self addColumn: attributes];
        }
        
        memset(&attributes, 0, sizeof(DWTableControllerAttributes));
        
        n = NSLocalizedStringFromTable(@"File Size", @"QueryResultsTable", @"Column name");
        s = NSLocalizedStringFromTable(@"Size", @"QueryResultsTable", @"Short column name");
        attributes.identifier = @"col_size";
        attributes.name       = n;
        attributes.shortName  = s;
        attributes.flags      = DWCenterAligned | DWDefault | DWTableStringValue;
        attributes.minWidth   = 60;
        attributes.maxWidth   = 60;
        attributes.sel        = @selector(sizeTS);
        attributes.comparator = compareColSize;

        [self addColumn: attributes];
        memset(&attributes, 0, sizeof(DWTableControllerAttributes));
        
        n = NSLocalizedStringFromTable(@"MP3 Bitrate", @"QueryResultsTable", @"Column name");
        s = NSLocalizedStringFromTable(@"Bitrate", @"QueryResultsTable", @"Short column name");
        attributes.identifier = @"col_bitrate";
        attributes.name       = n;
        attributes.shortName  = s;
        attributes.flags      = DWCenterAligned | DWDefault | DWImageAccessor;
        attributes.minWidth   = 60;
        attributes.maxWidth   = 60;
        attributes.sel        = @selector(bitrateAsByteSize);
        attributes.comparator = compareColBitrate;

        [self addColumn: attributes];
        /*
        memset(&attributes, 0, sizeof(DWTableControllerAttributes));
            
        n = NSLocalizedStringFromTable(@"Album Title", @"QueryResultsTable", @"Column name");
        s = NSLocalizedStringFromTable(@"Album", @"QueryResultsTable", @"Short column name");
        attributes.identifier = @"col_album";
        attributes.name       = n;
        attributes.shortName  = s;
        attributes.flags      = DWTableStringValue | DWSortAscendingFirst;
        attributes.minWidth   = 60;
        attributes.maxWidth   = 150;
        attributes.sel        = @selector(albumAsTableString);
        attributes.comparator = compareColAlbum;

        [self addColumn: attributes];*/
    }

@end