/*
** AqQueryDataSource(Actions)
** 
** CHANGES:
** 0.1 (pozytron) Added Song/Artist Name to Context Menu
*/

#import "AqBrowseHostToolbarView.h"
#import "AqQueryDataSource(Actions).h"
#import "AqDrawerController.h"
#import "NSMenuExtensions.h"


@implementation AqQueryDataSource (Actions)

/* Context Menu */

    #define DOWNLOAD NSLocalizedStringFromTable(@"Download", @"QueryResultsContextMenu", @"")
    #define UNKNOWNARTIST NSLocalizedStringFromTable(@"Unknown Artist", @"MetaBrowser", @"")
    #define UNKNOWNALBUM NSLocalizedStringFromTable(@"Unknown Album", @"MetaBrowser", @"")
    #define CLEARALLRESULTS NSLocalizedStringFromTable(@"Clear All Results", @"QueryResultsContextMenu", @"")

    - (id) menuForEvent: (NSEvent*) theEvent; 
    {
        int row = [tableView rowAtPoint: [theEvent locationInView: tableView]];
        if (row >= 0 && ![tableView isRowSelected: row])
            [tableView selectRow: row byExtendingSelection: NO];
        BOOL atLeastOneRowSelected = ([tableView selectedRow] >= 0);
        int numRows = [[[tableView selectedRowEnumerator] allObjects] count];
        [[tableView window] makeFirstResponder: tableView];
        
        /* build menu */
        
            NSMenu* m = [[[NSMenu alloc] initWithTitle: @""] autorelease];
            
            if (numRows==1) { // Only works if exactly one row is selected
                AqRemoteFile *theObj = [self objectAtRow: [tableView selectedRow]];
                if ([theObj mediaType] == kAqMusic && theObj->title) {
                    if (theObj->artist) {
                        NSMenuItem* artistItem = [[[NSMenuItem alloc] initWithTitle: theObj->artist action: @selector(searchFromMenu:) keyEquivalent: @""] autorelease];
                        [artistItem setTarget: [AqDrawerController instance]];
                        [artistItem setImage: [NSImage imageNamed:@"AcqFindSmall"]];
                        [m addItem: artistItem];
                    } else [m addItemWithTitle: UNKNOWNARTIST action: nil target: self];
                    NSMenuItem* titleItem = [[[NSMenuItem alloc] initWithTitle: theObj->title action: @selector(searchFromMenu:) keyEquivalent: @""] autorelease];
                    [titleItem setTarget: [AqDrawerController instance]];
                    [titleItem setImage: [NSImage imageNamed:@"AcqFindSmall"]];
                    [m addItem: titleItem];
                    if (theObj->album) {
                        NSMenuItem* albumItem = [[[NSMenuItem alloc] initWithTitle: theObj->album action: @selector(searchFromMenu:) keyEquivalent: @""] autorelease];
                        [albumItem setTarget: [AqDrawerController instance]];
                        [albumItem setImage: [NSImage imageNamed:@"AcqFindSmall"]];
                        [m addItem: albumItem];
                    } else [m addItemWithTitle: UNKNOWNALBUM action: nil target: self];
                    [m addSeparator];
                }
            }
    
            if (atLeastOneRowSelected)
                [m addItemWithTitle: DOWNLOAD action: @selector(downloadSelected:) target: self];
            [m addItemWithTitle: CLEARALLRESULTS action: @selector(removeAll:) target: self];
            
        /* browse host */
            
            [AqBrowseHostToolbarView addBrowseableHostsToMenu: m];

        return m;
    }
    

/* Actions */

    - (void) removeAll: (id) sender; {
        [query removeAllObjects];
        [self updateCell: nil];
    }

    - (void) downloadSelected: (id) sender; {
        id n, e = [tableView selectedRowEnumerator];
        id downloads = [[NSMutableArray alloc] init];
 
        while ((n = [e nextObject])) 
        {
            id selectedObject = [self objectAtRow: [n intValue]];
            
            [downloads addObject: selectedObject];
            [selectedObject download];
        }
           
        [tableView setNeedsDisplay: YES];
        [downloads release];
    }

    - (void) doubleAction: (id) sender; {
        if ([sender clickedRow] >= 0) {
            [self downloadSelected: self];
        }
    }

    - (void) enterKeyPressed; {
        [self downloadSelected: nil];
    }

    - (void) spaceKeyPressed; {
        [self downloadSelected: nil];
    }

    - (void) deleteKeyPressed; {
        id o, e = [[self selectedObjects] objectEnumerator];
        while ((o = [e nextObject])) {
            [objects removeObject: o];
        }
        [tableView deselectAll: self];
        [tableView noteNumberOfRowsChanged];
        
        [self updateCell: nil];
    }

@end