#import "AqAdultFilter.h"
/*
** AqQueryController
** 
** CHANGES:
** 0.23 (pozytron) Fixed scrollbar bug
*/

#import "AqBrowseHostQuery.h"
#import "AqCoreController.h"
#import "AqDrawerController.h"
#import "AqQueryController.h"
#import "AqURLHandler.h"
#import "NSUserDefaultsExtensions.h"


@implementation AqQueryController

/* Instance */

    + (id) instance; {
        static id instance = nil;
        if (!instance) instance = [[AqQueryController alloc] init];
        return instance;
    }


/* Initialization */
    
    - (id) init; {
        queries = [[NSMutableArray alloc] init];
        indexToQuery = [[NSMutableDictionary alloc] init];
        return [super init];
    }

    - (void) loadDefaults; {
        id defaultStrings = [defaults arrayForKey: @"kAqQueryControllerStringsKey"];
    
        if (!defaultStrings) {
            defaultStrings = [NSArray arrayWithObjects: @"Sample Search", nil];
            [defaults setObject: defaultStrings forKey: @"kAqQueryControllerStringsKey"];
        }
    
        unsigned i;
        for (i=0; i<[defaultStrings count]; i++) {
            id string = [defaultStrings objectAtIndex: i];
            if ([string hasPrefix: @"acquisition:"]) {
                [AqURLHandler handleURLString: string];
                [self queryAtIndex: [self count]-1]->keepInDrawer = YES;
            } else {
                [queries addObject: [[[AqQuery alloc] initWithString: string] autorelease]];
            }
        }
        [[AqDrawerController instance]->queryView addOrRemoveScroller];
    }
    
    - (void) applicationWillTerminate; {
        id strings = [[[NSMutableArray alloc] init] autorelease];

        int i, count = [self count];
        for (i=0; i<count; i++) {
            AqQuery* query = [self queryAtIndex: i];
            if (query->keepInDrawer) {
                [strings addObject: [query defaultsString]];
            }
        }
        
        [defaults setObject: strings forKey: @"kAqQueryControllerStringsKey"];
    }


#pragma mark -
/* Events */

    - (void) handleQueryReply: (id) theInfo; 
    {
        /* adult filter */
        
            if ([[AqAdultFilter instance] shouldCensorName: [theInfo objectAtIndex: 9]]) {
                //NSLog(@"- adult: %@", [theInfo objectAtIndex: 9]);
                return;
            }

        /* the AqQuery this is intended for */

            id index = [theInfo objectAtIndex: 1];
            [[indexToQuery objectForKey: index] handleQueryReply: theInfo intendedForMe: YES];
        
        /* everyone else */
        
            #if 0
            int i;
            for (i=0; i<[self count]; i++) {
                [[self queryAtIndex: i] handleQueryReply: theInfo intendedForMe: NO];
            }
            #endif
    }
    
    - (void) coreDidTerminate; {
        lastQueryIndex = 0;
        [indexToQuery removeAllObjects];
    }


#pragma mark -
/* Elements */

    - (AqQuery*) queryAtIndex: (int) index; {
        return [queries objectAtIndex: index];
    }

    - (int) indexOfQuery: (id) value; {
        return [queries indexOfObject: value];
    }

    - (unsigned) count; {
        return [queries count];
    }
    

#pragma mark -
/* ...AtIndex */

    #define queryAtIndex ((AqQuery*)[queries objectAtIndex: index])
    
    - (id) stringAtIndex: (int) index; {
        return queryAtIndex->string;
    }

    - (id) queryStringAtIndex: (int) index; {
        return [queryAtIndex queryString];
    }
    
    - (AqQueryState) stateAtIndex: (int) index; {
        return queryAtIndex->state;
    }

    - (BOOL) isActiveAtIndex: (int) index; {
        return queryAtIndex->state == kAqQueryControllerActive;
    }

    - (BOOL) hasResultsAtIndex: (int) index; {
        return [queryAtIndex count] > 0;
    }
    
    - (id) sourceAtIndex: (int) index; {
        return queryAtIndex->dataSource;
    }
    
    - (AqQueryCell*) cellAtIndex: (int) index; {
        return queryAtIndex->cell;
    }
    
    - (id) viewAtIndex: (int) index; {
        return queryAtIndex->splitView;
    }

    - (BOOL) userCanStartQueryAtIndex: (int) index; {
        return ![queryAtIndex isKindOfClass: [AqBrowseHostQuery class]];
    }
    
    - (BOOL) userCanStopQueryAtIndex:  (int) index; {
        return ![queryAtIndex isKindOfClass: [AqBrowseHostQuery class]];
    }

    
#pragma mark -
/* Queries */

    - (BOOL) hasQuery: (NSString*) theString; {
        return [queries containsObject: theString];
    }
    
    - (int) lastStringQueryIndex; {
        unsigned i;
        for (i=0; i<[self count]; i++) {
            if ([[queries objectAtIndex: i] isKindOfClass: [AqBrowseHostQuery class]]) {
                return i-1;
            }
        }
        return i-1;
    }

    - (void) parseAndAddQuery: (NSString*) theQuery; {
        /* check to see if this looks like an IP address */
        //aa
    }
    
    - (void) addQuery: (AqQuery*) theQuery; {
        if (![self hasQuery: [theQuery string]]) {
            if ([theQuery isKindOfClass: [AqBrowseHostQuery class]])
                [queries addObject: theQuery];
            else
                [queries insertObject: theQuery atIndex: [self lastStringQueryIndex]+1];
            [defaults synchronize];
        }
        [self setActive: YES atIndex: [self indexOfQuery: [theQuery string]]];
    }

    - (void) removeQueryAtIndex: (unsigned) index; {
        if (index >= 0 && index < [self count]) {
            [indexToQuery removeObject: queryAtIndex];
            [queries removeObjectAtIndex: index];
            [defaults synchronize];
        }
    }
    
    
#pragma mark -
/* Starting & Stopping Queries */

    - (void) setActive: (BOOL) isActive atIndex: (int) index; {
        queryAtIndex->state = (isActive) ? kAqQueryControllerActive : kAqQueryControllerNotActive;
        queryAtIndex->cell->isActive = isActive;
        
        if (isActive) {
            [queryAtIndex sendQuery];
            [indexToQuery setObject: queryAtIndex forKey: [NSString stringWithFormat: @"%i", lastQueryIndex]];
            lastQueryIndex++;
        } else {
            //[indexToQuery removeObject: queryAtIndex];
        }
    }
    
@end