#import "DWObject.h"
#import "AqQueryCell.h"
#import "AqQuery.h"

#define AqQC [AqQueryController instance]

/*
    AqQueryController merely maintains the list of current queries.  Embodied within each query is state information, as well as user interface elements.  The AqQueryController is responsible for maintaining this list of queries across sessions via the defaults system.
*/

@interface AqQueryController : DWObject 
{
    id queries;
    id indexToQuery;
    int lastQueryIndex;
}

+ (id) instance;
- (void) loadDefaults;

- (void) handleQueryReply: (id) theInfo;
- (void) coreDidTerminate;

- (AqQuery*) queryAtIndex: (int) index;
- (int) indexOfQuery: (id) value;
- (unsigned) count;

- (id) stringAtIndex: 		(int) index;
- (id) queryStringAtIndex: 	(int) index;
- (AqQueryState) stateAtIndex: 	(int) index;
- (BOOL) isActiveAtIndex: 	(int) index;
- (BOOL) hasResultsAtIndex: 	(int) index;
- (id) sourceAtIndex: 		(int) index;
- (AqQueryCell*) cellAtIndex: 	(int) index;
- (id) viewAtIndex: 		(int) index;

- (BOOL) userCanStartQueryAtIndex: (int) index;
- (BOOL) userCanStopQueryAtIndex:  (int) index;

- (BOOL) hasQuery: (NSString*) theString;
- (void) parseAndAddQuery: (NSString*) theQuery;
- (void) addQuery: (AqQuery*) theQuery;
- (void) removeQueryAtIndex: (unsigned) index;

- (void) setActive: (BOOL) value atIndex: (int) index;

@end