#import "AqBrowserView.h"
#import "AqCoreController.h"
#import "AqQueryCell.h"


typedef enum {
    kAqQueryControllerNotActive = 0,
    kAqQueryControllerActive    = 1
} AqQueryState;


@interface AqQuery : NSObject
{
    @public
    id string;

    id positive;
    id negative;
    id neutral;

    id files;
    id hashToFile;
    id uniqueDescriptors;
    
    BOOL keepInDrawer;
    
    /* ui */
    AqQueryState state;
    id dataSource;
    id splitView;
    AqQueryCell* cell;
    AqBrowserView* browserView;
}

- (id) initWithString: (NSString*) theString;
- (void) initView;

- (void) sendQuery;
- (void) handleQueryReply: (id) theInfo intendedForMe: (BOOL) forMe;

- (void) parseQueryString;
- (id) queryString;

- (id) string;
- (id) defaultsString;

- (id) dataSource;
- (unsigned) count;
- (void) removeAllObjects;

@end