#import "AqBrowseHostQuery.h"
#import "AqDrawerController.h"
#import "AqQueryController.h"
#import "AqURLHandler.h"


@implementation AqBrowseHostQuery

/* Initialization */

    - (id) initWithString: (id) theString; 
    {
        self = [self init];
        
        id hostinfo = [theString componentsSeparatedByString: @":"];
        
        if ([hostinfo count] == 1) {
            host = [[hostinfo objectAtIndex: 0] retain];
            port = 6346;
        } else if ([hostinfo count] >= 2) {
            host = [[hostinfo objectAtIndex: 0] retain];
            port = [[hostinfo objectAtIndex: 1] intValue];
        }

        keepInDrawer = NO;
        string = [theString retain];

        cell = [[AqQueryCell alloc] init];
          [cell setPrimary: [[[DWTableString alloc] initWithString: string attributes: [AqQueryCell primaryAttributes]] autorelease]];
          cell->isBrowseHostCell = YES;

        return self;
    }
    
    - (void) dealloc; {
        [super dealloc];
        [host release];
    }
    
    - (id) defaultsString; {
        return [AqURLHandler browseURLForAddress: string];
    }


/* Querying */
    
    - (void) sendQuery; {
        [AqCoreController writeString: [NSString stringWithFormat: @"doBrowseHost|%@|%i\n", host, port]];
    }
    

/* Stopping */
    
    - (void) stop; {
        [[AqDrawerController instance] setActive: NO atIndex: [AqQC indexOfQuery: self]];
        if (![self count] && !keepInDrawer) {
            [AqQC removeQueryAtIndex: [AqQC indexOfQuery: self]];
            [[AqDrawerController instance]->queryView noteNumberOfRowsChanged];
        }
    }

@end