/*
** AqiTunesPreferences
** 
** CHANGES:
** 0.1 (pozytron) Added Preference for Name of Playlist
*/

#import "AqiTunesPreferences.h"


@implementation AqiTunesPreferences

/* Register Defaults */

    - (void) registerDefaults; 
    {
        id dict = [[[NSMutableDictionary alloc] init] autorelease];
    
        [dict setObject: @"1"		forKey: @"kAqAddSong"];
        [dict setObject: @"1"		forKey: @"kAqAddSongToPlaylist"];
        //[dict setObject: @"1"		forKey: @"kAqPlaylistShouldLimit"];
        //[dict setObject: @"2"		forKey: @"kAqPlaylistLimit"];
        [dict setObject: @"0"		forKey: @"kAqPlaySong"];
        [dict setObject: @"0"		forKey: @"kAqDeleteAfterImport"];
        [dict setObject: @"AcqLite"     forKey: @"kAqPlaylistName"];
            
        [defaults registerDefaults: dict];
    }


/* Load Defaults */

    - (void) loadDefaults; 
    {
        /* Add Song */
        
            tempBool = [defaults boolForKey: @"kAqAddSong"];
            [addSong setState: (tempBool) ? NSOnState : NSOffState];

            [addSongToPlaylist setEnabled: tempBool];
            [playSong setEnabled: tempBool];
            [playlistName setEnabled: tempBool];
            [deleteAfterImport setEnabled: tempBool];

        /* Add Song to Playlist */
        
            tempBool = [defaults boolForKey: @"kAqAddSongToPlaylist"];
            [addSongToPlaylist setState: (tempBool) ? NSOnState : NSOffState];
            
//            [playlistShouldLimit setEnabled: tempBool && [addSongToPlaylist isEnabled]];
            
        /* Should Limit Playlist Length */
/*        
            tempBool = [defaults boolForKey: @"kAqPlaylistShouldLimit"];
            [playlistShouldLimit setState: (tempBool) ? NSOnState : NSOffState];

            [playlistLimit setEnabled: tempBool && [playlistShouldLimit isEnabled]];
*/
        /* Playlist Limit */
/*
            tempInt = [defaults integerForKey: @"kAqPlaylistLimit"];
            [playlistLimit selectItemAtIndex: tempInt];
*/
        /* Play Song */
            
            tempInt = [defaults integerForKey: @"kAqPlaySong"];
            [playSong selectCellAtRow: tempInt column: 0];

        /* Delete After Import */
            
            tempBool = [defaults boolForKey: @"kAqDeleteAfterImport"];
            [deleteAfterImport setState: (tempBool) ? NSOnState : NSOffState];
        
        /* Playlist Name */
            
            [playlistName setStringValue:[defaults objectForKey: @"kAqPlaylistName"]];
    }


/* Mutate Defaults */

    - (void) addSong: (id) sender; {
        tempBool = [sender intValue];
        [defaults setBool: tempBool forKey: @"kAqAddSong"];
        [self loadDefaults];
    }
    
    - (void) addSongToPlayList: (id) sender; {
        tempBool = [sender intValue];
        [defaults setBool: tempBool forKey: @"kAqAddSongToPlaylist"];
        [self loadDefaults];
    }
/*
    - (void) playlistShouldLimit: (id) sender; {
        tempBool = [sender intValue];
        [defaults setBool: tempBool forKey: @"kAqPlaylistShouldLimit"];
        [self loadDefaults];
    }

    - (void) playlistLimit: (id) sender; {
        [defaults setInteger: [sender indexOfSelectedItem] forKey: @"kAqPlaylistLimit"];
        [self loadDefaults];
    }
*/    
    - (void) playSong: (id) sender; {
        [defaults setInteger: [sender selectedRow] forKey: @"kAqPlaySong"];
        [self loadDefaults];
    }

    - (void) deleteAfterImport: (id) sender; {
        tempBool = [sender intValue];
        [defaults setBool: tempBool forKey: @"kAqDeleteAfterImport"];
        [self loadDefaults];
    }

    - (void) playlistName: (id) sender; {
        [defaults setObject: [sender stringValue] forKey: @"kAqPlaylistName"];
        [self loadDefaults];
    }

@end