#import "AqSharingPreferences.h"
#import "AqIconCell.h"


@implementation AqSharingPreferences

/* Awake */

    - (void) awakeFromNib; 
    {
        [super awakeFromNib];

        /* Set up the table view */
        
            [[sharedDirectoriesView tableColumnWithIdentifier: @"kAqSharingIconColumn"] setDataCell: [[AqIconCell alloc] init]];
            [sharedDirectoriesView setTarget: self];
            [sharedDirectoriesView setDoubleAction: @selector(openSelected:)];
            
            [[NSNotificationCenter defaultCenter] addObserver: self selector: @selector(sharedDirectoriesViewSelectionDidChange:) name: NSTableViewSelectionDidChangeNotification object: sharedDirectoriesView];
    }
    

/* Register Defaults */

    - (void) registerDefaults; 
    {
        id dict = [[[NSMutableDictionary alloc] init] autorelease];
    
        [dict setObject: @""		forKey: @"kAqSharedDirectories"];
        [dict setObject: @"5"		forKey: @"kAqMaxUploads"];
        [dict setObject: @"2"		forKey: @"kAqMaxUploadsPerPerson"];
            
        [defaults registerDefaults: dict];
    }


/* Load Defaults */

    /*
        loadDefaultsWithDirectories is added here since every time the directories list is pushed
        into the core, the directories are traversed and the list of shared files rebuilt.  This is
        understandably costly, and so we wish to avoid it when doing trivial updates to the other
        parameters.
    */
    
    - (void) loadDefaults; {
        [self loadDefaultsWithDirectories: YES];
    }

    - (void) loadDefaultsWithDirectories: (BOOL) shouldSetDirectories;
    {
        /* Max Uploads */
        
            tempInt = [defaults integerForKey: @"kAqMaxUploads"];
            if (tempInt < 1) tempInt = 1;
            [maxUploadsPopup selectItemWithTitle: [defaults stringForKey: @"kAqMaxUploads"]];

            [AqCoreController writeString: [NSString stringWithFormat: @"setMaxUploads|%i\n", tempInt]];
        
        /* Max Uploads Per Person */
        
            tempInt = [defaults integerForKey: @"kAqMaxUploadsPerPerson"];
            [maxUploadsPerPersonPopup selectItemWithTitle: [defaults stringForKey: @"kAqMaxUploadsPerPerson"]];

            [AqCoreController writeString: [NSString stringWithFormat: @"setUploadsPerPerson|%i\n", tempInt]];

        /* Shared Directories */
        
            if (!shouldSetDirectories)
                return;

            [sharedDirectoriesArray release];
            sharedDirectoriesArray = [[NSMutableArray alloc] initWithArray: [defaults arrayForKey: @"kAqSharedDirectories"]];

            [sharedDirectoriesView noteNumberOfRowsChanged];
            
            [AqCoreController writeString: [NSString stringWithFormat: @"setDirectories|%@\n", [sharedDirectoriesArray componentsJoinedByString: @";"]]];
    }
    

/* Mutate Defaults */

    - (void) addFolder: (id) sender; {
        NSOpenPanel* openPanel = [NSOpenPanel openPanel];
            [openPanel setCanChooseFiles: NO];
            [openPanel setCanChooseDirectories: YES];
        [openPanel beginSheetForDirectory: nil file: nil types: nil modalForWindow: panel modalDelegate: self didEndSelector: @selector(addFolder:returnCode:contextInfo:) contextInfo: nil];
    }

    - (void) addFolder: (id) openPanel returnCode: (int) code contextInfo: (void*) info; {
        if (code == NSOKButton) {
            tempString = [openPanel directory];
            if (![sharedDirectoriesArray containsObject: tempString]) {
                [sharedDirectoriesArray addObject: tempString];
                [defaults setObject: sharedDirectoriesArray forKey: @"kAqSharedDirectories"];
                [self loadDefaults];
            }
        }
        //[panel makeKeyAndOrderFront: self]; 
    }
    
    - (void) removeSelectedFolders: (id) sender; 
    {
        id o, e = [sharedDirectoriesView selectedRowEnumerator];
        id toRemove = [[[NSMutableArray alloc] init] autorelease];
        
        while ((o = [e nextObject])) {
            [toRemove addObject: [sharedDirectoriesArray objectAtIndex: [o intValue]]];
        }
        
        [sharedDirectoriesArray removeObjectsInArray: toRemove];
        [sharedDirectoriesView deselectAll: self];
        
        [defaults setObject: sharedDirectoriesArray forKey: @"kAqSharedDirectories"];
        [self loadDefaults];
    }
    
    - (void) changeMaxUploads: (id) sender; {
        [defaults setObject: [[sender selectedItem] title] forKey: @"kAqMaxUploads"];
        [self loadDefaultsWithDirectories: NO];
    }
    
    - (void) changeMaxUploadsPerPerson: (id) sender; {
        [defaults setObject: [[sender selectedItem] title] forKey: @"kAqMaxUploadsPerPerson"];
        [self loadDefaultsWithDirectories: NO];
    }


/* Directories table */
    
    - (int) numberOfRowsInTableView: (id) theView; {
        return [sharedDirectoriesArray count];
    }
    
    - (id) tableView: (id) theView objectValueForTableColumn: (id) col row: (int) row; {
        return [[sharedDirectoriesArray objectAtIndex: row] stringByAbbreviatingWithTildeInPath];
    }
    
    - (void) openSelected: (id) sender; {
        if ([sender clickedRow] < 0) return;
        int row = [sharedDirectoriesView selectedRow];
        if (row >= 0) {
            id path = [sharedDirectoriesArray objectAtIndex: row];
            [[NSWorkspace sharedWorkspace] openFile: path];
        }
    }
    
    /* 
        This is used to toggle the "Remove" button on and off depending if anything is selected in the shared directories table view.
    */
    
    - (void) sharedDirectoriesViewSelectionDidChange: (id) sender; {
        [removeButton setEnabled: [sharedDirectoriesView selectedRow] >= 0];
    }
    
@end