/*
** AqPreferencesController
** 
** CHANGES:
** 0.1  (pozytron) Removed Registration Preferences
** 0.23 (pozytron) Changed iTunes Prefs to "Download Actions" 
*/

#import "AqPreferencesController.h"


@implementation AqPreferencesController

/* Strings */

    #define GENERAL     NSLocalizedStringFromTable(@"General", @"Preferences", @"General toolbar item")
    #define NETWORK     NSLocalizedStringFromTable(@"Network", @"Preferences", @"Network toolbar item")
    #define DOWNLOAD    NSLocalizedStringFromTable(@"Download", @"Preferences", @"Download toolbar item")
    #define SHARING     NSLocalizedStringFromTable(@"Sharing", @"Preferences", @"Sharing toolbar item")
    #define ITUNES     NSLocalizedStringFromTable(@"iTunes", @"Preferences", @"iTunes toolbar item")
    

/* Awake */
    
    static id instance = nil;

    + (id) instance; {
        return instance;
    }

    - (void) awakeFromNib; 
    {
        toolbar = [[NSToolbar alloc] initWithIdentifier: @"AqPreferencesToolbar"];

        [self initItems];
        instance = self;
           
        [toolbar setDelegate: self];
        [toolbar setAllowsUserCustomization: NO];
        [toolbar setAutosavesConfiguration: NO];
                
        [window setToolbar: toolbar];
        [window center];
        [window setDelegate: self];
        
        frame_general       = [view_general frame];
        frame_network       = [view_network frame];
        frame_download      = [view_download frame];
        frame_upload        = [view_upload frame];
//        frame_filter        = [view_filter frame];
        frame_itunes       = [view_itunes frame];
        
        [self showGeneralPreferences: self];
    }


/* Initialization of Toolbar Items */
    
    - (void) initItems; 
    {
        item_general = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_general"];
            [item_general setLabel: GENERAL];
            [item_general setTarget: self];
            [item_general setAction: @selector(showGeneralPreferences:)];
            [item_general setImage: [NSImage imageNamed: @"general"]];

        item_network = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_network"];
            [item_network setLabel: NETWORK];
            [item_network setTarget: self];
            [item_network setAction: @selector(showNetworkPreferences:)];
            [item_network setImage: [NSImage imageNamed: @"network"]];

        item_download = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_download"];
            [item_download setLabel: DOWNLOAD];
            [item_download setTarget: self];
            [item_download setAction: @selector(showDownloadPreferences:)];
            [item_download setImage: [NSImage imageNamed: @"AcqDownload"]];

        item_upload = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_upload"];
            [item_upload setLabel: SHARING];
            [item_upload setTarget: self];
            [item_upload setAction: @selector(showUploadPreferences:)];
            [item_upload setImage: [NSImage imageNamed: @"AcqUpload"]];

        /*
        item_filter = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_filter"];
            [item_filter setLabel:@"Filtering"];
            [item_filter setTarget: self];
            [item_filter setAction: @selector(showFilterPreferences:)];
            [item_filter setImage: [NSImage imageNamed: @"filterPrefs"]];
        */

        item_itunes = [[NSToolbarItem alloc] initWithItemIdentifier: @"item_itunes"];
            [item_itunes setLabel: ITUNES];
            [item_itunes setTarget: self];
            [item_itunes setAction: @selector(showiTunesPreferences:)];
            [item_itunes setImage: [NSImage imageNamed: @"itunes"]];
    }


#pragma mark -
/* NSToolbar Delegate */

    - (id) toolbar: (id) tb itemForItemIdentifier: (id) ident willBeInsertedIntoToolbar: (BOOL) will; {
        return [self valueForKey: ident];
    }
    
    - (id) toolbarDefaultItemIdentifiers: (id) tb; {
        NSMutableArray* array = [[NSMutableArray alloc] init];
        [array addObjectsFromArray: [NSArray arrayWithObjects:
            @"item_general",
            @"item_network",
            @"item_download",
            @"item_upload",
            @"item_itunes",
            //@"item_filter",
            nil]];
        return array;
    }
    
    - (id) toolbarAllowedItemIdentifiers: (id) tb; {
        NSMutableArray* array = [[NSMutableArray alloc] init];
        [array addObjectsFromArray: [NSArray arrayWithObjects:	
            @"item_general",
            @"item_network",
            @"item_download",
            @"item_upload",
            @"item_itunes",
            //@"item_filter",
            nil]];
        return array;
    }


#pragma mark -
/* Window Resizing */

    - (void) setWindowResizable: (BOOL) shouldResize; {
        isWindowResizable = shouldResize;
        [window setShowsResizeIndicator: shouldResize];
    }
    
    - (NSSize) windowWillResize: (NSWindow*) sender toSize: (NSSize) proposedFrameSize; {
        return (isWindowResizable) ? proposedFrameSize : [window frame].size;
    }


#pragma mark -
/* View Changes */

    - (void) switchToView: (id) view; 
    {
        if ([window contentView] != view)
        {
            NSRect windowFrame = [window frame];
            NSSize minSize;
            float newHeight;
            float oldHeight = [window frame].size.height;
            float toolbarHeight = [window frame].size.height - [[window contentView] frame].size.height;
            
            if (view == view_general)           minSize = frame_general.size;
            if (view == view_network)           minSize = frame_network.size;
            if (view == view_download)          minSize = frame_download.size;
            if (view == view_upload)            minSize = frame_upload.size;
//            if (view == view_filter)            minSize = frame_filter.size;
            if (view == view_itunes)           minSize = frame_itunes.size;
            
            newHeight = [view frame].size.height;
            newHeight += toolbarHeight;
    
            if (newHeight != oldHeight) {
                [window setContentView: [[[NSView alloc] initWithFrame: windowFrame] autorelease]];
                [window display];
            }
    
            windowFrame.size.height = newHeight;
            windowFrame.origin.y -= (newHeight - oldHeight);
            windowFrame.size.width = [view frame].size.width;
    
            [window setFrame: windowFrame display: YES animate: YES];
            [window setMinSize: NSMakeSize(minSize.width, minSize.height + 22)];
            [window setContentView: view];
        }
    }
    

#pragma mark -
/* Toolbar Actions */

    //#define setWindowTitle(A) [window setTitle: [NSString stringWithFormat: @"AcqLite - %@ Preferences", A]]
    #define setWindowTitle(A) [window setTitle: A]

    - (void) showGeneralPreferences: (id) sender; {
        [self setWindowResizable: NO];
        [self switchToView: view_general];
        //[toolbar setSelectedItemIdentifier: @"item_general"];
        setWindowTitle(GENERAL);
    }
    
    - (void) showNetworkPreferences: (id) sender; {
        [self setWindowResizable: NO];
        [self switchToView: view_network];
        //[toolbar setSelectedItemIdentifier: @"item_general"];
        //[toolbar validateVisibleItems];
        setWindowTitle(NETWORK);
    }
    
    - (void) showDownloadPreferences: (id) sender; {
        [window makeKeyAndOrderFront: nil];
        [self setWindowResizable: NO];
        [self switchToView: view_download];
        setWindowTitle(DOWNLOAD);
    }
    
    - (void) showUploadPreferences: (id) sender; {
        [window makeKeyAndOrderFront: nil];
        [self setWindowResizable: NO];
        [self switchToView: view_upload];
        setWindowTitle(SHARING);
    }

    /*
    - (void) showFilterPreferences: (id) sender; {
        [self setWindowResizable: NO];
        [self switchToView: view_filter];
        setWindowTitle(@"Filtering");
    }
    */

    - (void) showiTunesPreferences: (id) sender; {
        [window makeKeyAndOrderFront: nil];
        [self setWindowResizable: NO];
        [self switchToView: view_itunes];
        setWindowTitle(ITUNES);
    }

@end