/*
** AqNetworkPreferences
** 
** CHANGES:
** 0.11 (pozytron) Added Filter Non-LimeWire Preference
** 0.2  (pozytron) Changed Max. Ultrapeers to 6
** 0.23 (pozytron) Changed Hard Maximum to 32, default to 4
*/

#import "AqNetworkPreferences.h"


@implementation AqNetworkPreferences

/* Register Defaults */

    - (void) registerDefaults; 
    {
        id dict = [[[NSMutableDictionary alloc] init] autorelease];
    
        [dict setObject: @"5"		forKey: @"keep_alive"];
        [dict setObject: @"350"		forKey: @"connection_speed"];
        [dict setObject: @"6346"	forKey: @"port"];
        [dict setObject: @"1"		forKey: @"enable_ultrapeer"];
        [dict setObject: @"100"		forKey: @"upstream_limit"];
        [dict setObject: @"0"		forKey: @"filter_unfriendly"];
            
        [defaults registerDefaults: dict];
    }


/* Load Defaults */

    - (void) loadDefaults; 
    {
        /* Keep Alive */
        
            tempInt = [defaults integerForKey: @"keep_alive"];
            if (tempInt > 5) tempInt = 5;
            [keep_alive selectItemWithTitle: [NSString stringWithFormat: @"%i", tempInt]];
            [AqCoreController writeString: [NSString stringWithFormat: @"setKeepAlive|%i\n", tempInt]];
            
        /* Connection Speed */
        
            tempInt = [defaults integerForKey: @"connection_speed"];
            if (tempInt >= 1000)      [connection_speed selectItemAtIndex: 2];
            else if (tempInt >= 350)  [connection_speed selectItemAtIndex: 1];
            else                      [connection_speed selectItemAtIndex: 0];
            [AqCoreController writeString: [NSString stringWithFormat: @"setConnectionSpeed|%i\n", tempInt]];
            
            if (tempInt < 350) {
                [enable_ultrapeer setEnabled: false];
                [defaults setBool: NO forKey: @"enable_ultrapeer"];
            } else {
                [enable_ultrapeer setEnabled: true];
            }
            
        /* Port */
        
            tempInt = [defaults integerForKey: @"port"];
            [port setIntValue: tempInt];
            [AqCoreController writeString: [NSString stringWithFormat: @"setPort|%i\n", tempInt]];
            
        /* Ultrapeers */
            
            tempBool = [defaults boolForKey: @"enable_ultrapeer"];
            [enable_ultrapeer setState: (tempBool) ? NSOnState : NSOffState];
            [AqCoreController writeString: [NSString stringWithFormat: @"setEnableUltrapeer|%i\n", (tempBool) ? 1 : 0]];
            
	/* Filter Non-LimeWire (AcqLite 0.11) */
	    
            tempBool = [defaults boolForKey: @"filter_unfriendly"];
            [filter_unfriendly setState: (tempBool) ? NSOnState : NSOffState];
            [AqCoreController writeString: [NSString stringWithFormat: @"setFilterUnf|%i\n", (tempBool) ? 1 : 0]];
            
	/* Upstream Limit */

            [self loadUpstreamDefaults];
    }
    
    - (void) loadUpstreamDefaults; 
    {
        /* Upstream Limit */
        
            tempInt = [defaults integerForKey: @"upstream_limit"];
            if (tempInt > 100) tempInt = 100;
            if (tempInt < 10)  tempInt = 10;
            [upstream_limit setIntValue: tempInt];

            if (tempInt < 100) {
                [upstreamLimitTextPrimary setStringValue: [NSString stringWithFormat: @"%i%% of capacity.", tempInt]];
                [upstreamLimitTextSecondary setStringValue: [NSString stringWithFormat: @"%i kilobytes per second.", (int)(((float)tempInt/100.0f) * ([defaults integerForKey: @"connection_speed"]/8.0f))]];
            } else {
                [upstreamLimitTextPrimary setStringValue: @"No limit."];
                [upstreamLimitTextSecondary setStringValue: @""];
            }
            
            [AqCoreController writeString: [NSString stringWithFormat: @"setUploadSpeed|%i\n", tempInt]];
    }
    

/* Mutate Defaults */

    - (void) keep_alive: (id) sender; {
        [defaults setInteger: [[sender titleOfSelectedItem] intValue] forKey: @"keep_alive"];
        [self loadDefaults];
    }
    
    - (void) connection_speed: (id) sender; 
    {
        if ([sender indexOfSelectedItem] == 0)
            tempInt = 56;
        if ([sender indexOfSelectedItem] == 1)
            tempInt = 350;
        if ([sender indexOfSelectedItem] == 2)
            tempInt = 1000;
        [defaults setInteger: tempInt forKey: @"connection_speed"];
        [self loadDefaults];
    }
    
    - (void) port: (id) sender; 
    {
        tempInt = [sender intValue];
        
        if (tempInt < 1024 || tempInt > 65535) {
            NSBeginAlertSheet(@"You entered an invalid port number.", @"OK", nil, nil, panel, nil, nil, nil, nil, @"The port number must be in the range 1024 through 65535.");
        } else {
            [defaults setInteger: [sender intValue] forKey: @"port"];
        }
    
        [self loadDefaults];
    }
    
    - (void) enable_ultrapeer: (id) sender; {
	[defaults setBool: ([sender state] == NSOnState) forKey: @"enable_ultrapeer"];
        [self loadDefaults];
    }
    
    - (void) filter_unfriendly: (id) sender; {
        [defaults setBool: ([sender state] == NSOnState) forKey: @"filter_unfriendly"];
        [self loadDefaults];
    }

    - (void) upstream_limit: (id) sender; {
        [defaults setInteger: [sender intValue] forKey: @"upstream_limit"];
        [self loadUpstreamDefaults];
    }

@end