/*
** AqGeneralPreferences
** 
** CHANGES:
** 0.1  (pozytron) Added ID3 Tag Preference
** 0.23 (pozytron) Added downloadStatusInDock
*/

#import "AqAdultFilter.h"
#import "AqApplicationController.h"
#import "AqDownloadsController.h"
#import "AqDrawerController.h"
#import "AqGeneralPreferences.h"
#import "AqUploadsController.h"


@implementation AqGeneralPreferences

/* Register Defaults */

    - (void) registerDefaults;
    {
        id dict = [[[NSMutableDictionary alloc] init] autorelease];
    
        [dict setObject: @"0"		forKey: @"kAqAutoClearDownloads"];
        [dict setObject: @"1"		forKey: @"kAqAutoClearUploads"];
        [dict setObject: @"0"		forKey: @"kAqAdultFilter"];
        [dict setObject: @"0"		forKey: @"kAqPositiveFilter"];
        [dict setObject: @"1"		forKey: @"kAqID3SongTitle"];
        //[dict setObject: @"1"		forKey: @"AcqProgressInDock"];
        //[dict setObject: @"0"		forKey: @"AcqIconScheme"];
        
        [defaults registerDefaults: dict];
    }


/* Load Defaults */

    - (void) loadDefaults; 
    {
        tempBool = [defaults boolForKey: @"kAqAutoClearDownloads"];
        [autoClearDownloads setState: (tempBool) ? NSOnState : NSOffState];

        tempBool = [defaults boolForKey: @"kAqAutoClearUploads"];
        [autoClearUploads setState: (tempBool) ? NSOnState : NSOffState];

        tempBool = [defaults boolForKey: @"kAqAdultFilter"];
        [adultFilter setState: (tempBool) ? NSOnState : NSOffState];
        [[AqAdultFilter instance] setShouldCensor: tempBool];

        tempBool = [defaults boolForKey: @"kAqPositiveFilter"];
        [positiveFilter setState: (tempBool) ? NSOnState : NSOffState];

        tempBool = [defaults boolForKey: @"kAqID3SongTitle"];
        [id3SongTitle setState: (tempBool) ? NSOnState : NSOffState];
/*
        tempBool = [defaults boolForKey: @"AcqProgressInDock"];
        [downloadStatusInDock setState: (tempBool) ? NSOnState : NSOffState];

        tempBool = [defaults boolForKey: @"AcqIconScheme"];
        [iconScheme setState: (tempBool) ? NSOnState : NSOffState];
*/
    }


/* Mutate Defaults */

    - (void) autoClearDownloads: (id) sender; {
        [defaults setBool: ([sender state] == NSOnState) forKey: @"kAqAutoClearDownloads"];
        [self loadDefaults];
        
        if ([sender state] == NSOnState) [[AqDownloadsController instance] clearAllComplete: self];
    }
    
    - (void) autoClearUploads: (id) sender; {
        [defaults setBool: ([sender state] == NSOnState) forKey: @"kAqAutoClearUploads"];
        [self loadDefaults];

        if ([sender state] == NSOnState) [[AqUploadsController instance] clearAllComplete: self];
    }

    - (void) adultFilter: (id) sender; {
        [defaults setBool: ([sender state] == NSOnState) forKey: @"kAqAdultFilter"];
        [self loadDefaults];
    }
    
    - (void) positiveFilter: (id) sender; {
        [defaults setBool: ([sender state] == NSOnState) forKey: @"kAqPositiveFilter"];
        [self loadDefaults];
    }
    
    - (void) id3SongTitle : (id) sender; {
        [defaults setBool: ([sender state] == NSOnState) forKey: @"kAqID3SongTitle"];
        [self loadDefaults];
    }
/*    
    - (void) downloadStatusInDock : (id) sender; {
        [defaults setBool: ([sender state] == NSOnState) forKey: @"AcqProgressInDock"];
        [self loadDefaults];
        [AqApplicationController updateDockIcon];
    }
    
    - (void) iconScheme : (id) sender; {
        [defaults setBool: ([sender state] == NSOnState) forKey: @"AcqIconScheme"];
        [self loadDefaults];
        [AqApplicationController updateDockIcon];
    }
*/
@end