#import "AqDownloadPreferences.h"


#define kAqConcurrentDownloads @"kAqConcurrentDownloads"

@implementation AqDownloadPreferences

/* Register Defaults */

    - (void) registerDefaults; 
    {
        id dict = [[[NSMutableDictionary alloc] init] autorelease];
    
        [dict setObject: @"~/Music/"        forKey: @"save_directory"];
        [dict setObject: @"100"              forKey: kAqConcurrentDownloads];

        [defaults registerDefaults: dict];
    }


/* Load Defaults */

    - (void) loadDefaults; 
    {
        /* Complete */
        
            id cPath = [defaults stringForKey: @"save_directory"];
            [save_directory setStringValue: cPath];

            [AqCoreController writeString: [NSString stringWithFormat: @"setSaveDirectory|%@\n", [cPath stringByExpandingTildeInPath]]];

        /* Incomplete */
        
            
            tempString = [defaults stringForKey: @"incomplete_directory"];
            if (!tempString) {
                tempString = [cPath stringByAppendingPathComponent: @"Incomplete"];
                [defaults setObject: tempString forKey: @"incomplete_directory"];
            }
            [incomplete_directory setStringValue: tempString];

            [AqCoreController writeString: [NSString stringWithFormat: @"setIncompleteDirectory|%@\n", [tempString stringByExpandingTildeInPath]]];
            
        
        /* Limit */
        
            tempInt = [defaults integerForKey: kAqConcurrentDownloads];
            if (tempInt == 100) {
                [concurrentDownloads selectItem: [concurrentDownloads lastItem]];
            } else {
                [concurrentDownloads selectItemWithTitle: [NSString stringWithFormat: @"%i", tempInt]];
            }
            
            [AqCoreController writeString: [NSString stringWithFormat: @"setMaxSimDownload|%i\n", tempInt]];
    }
    

/* Mutate Defaults */

    - (void) save_directory_button: (id) sender; 
    {
        NSOpenPanel* openPanel = [NSOpenPanel openPanel];
            [openPanel setCanChooseFiles: NO];
            [openPanel setCanChooseDirectories: YES];
        [openPanel beginSheetForDirectory: [save_directory stringValue] file: nil types: nil modalForWindow: panel modalDelegate: self didEndSelector: @selector(save_directory_button:returnCode:contextInfo:) contextInfo: nil];
    }

    - (void) save_directory_button: (id) op returnCode: (int) code contextInfo: (void*) info; 
    {
        if (code != NSOKButton) return;
        
        tempString = [[op directory] stringByAbbreviatingWithTildeInPath];
        
        
        id complete = [defaults stringForKey: @"save_directory"];
        id incomplete = [defaults stringForKey: @"incomplete_directory"];
        
        if ([incomplete isEqual: [complete stringByAppendingPathComponent: @"Incomplete"]]) {
            [defaults setObject: [tempString stringByAppendingPathComponent: @"Incomplete"] forKey: @"incomplete_directory"];
        }
        
        
        [defaults setObject: tempString forKey: @"save_directory"];
        [self loadDefaults];
    }

    - (void) incomplete_directory_button: (id) sender; 
    {
        NSOpenPanel* openPanel = [NSOpenPanel openPanel];
            [openPanel setCanChooseFiles: NO];
            [openPanel setCanChooseDirectories: YES];
        [openPanel beginSheetForDirectory: [incomplete_directory stringValue] file: nil types: nil modalForWindow: panel modalDelegate: self didEndSelector: @selector(incomplete_directory_button:returnCode:contextInfo:) contextInfo: nil];
    }

    - (void) incomplete_directory_button: (id) op returnCode: (int) code contextInfo: (void*) info; 
    {
        if (code != NSOKButton) return;
        
        tempString = [[op directory] stringByAbbreviatingWithTildeInPath];
        [defaults setObject: tempString forKey: @"incomplete_directory"];
        [self loadDefaults];
    }

    - (void) concurrentDownloads: (id) sender; 
    {
        if ([sender selectedItem] == [sender lastItem]) {
            tempInt = 100;
        } else {
            tempInt = [[[sender selectedItem] title] intValue];
        }
        [defaults setInteger: tempInt forKey: kAqConcurrentDownloads];
        [self loadDefaults];
    }

@end