/*
** AcqActionsPreferences
** 
** CHANGES:
** 0.23 (pozytron) Class created
*/

#import "AcqActionsPreferences.h"
#import "AqMediaType.h"
#import "AqTransferController.h"

#define DEFAULT NSLocalizedStringFromTable(@"Default", @"QueryResultsContextMenu", @"String in Open With menus.")

@implementation AcqActionsPreferences

- (void) awakeFromNib; 
{
    [super awakeFromNib];
    
    [openImagesPopup setMenu: [AqTransferController imageMenuWithTarget: self]];
    [openVideosPopup setMenu: [AqTransferController videoMenuWithTarget: self]];
    [openMusicPopup setMenu: [AqTransferController musicMenuWithTarget: self]];
    [openTextPopup setMenu: [AqTransferController textMenuWithTarget: self]];
}

- (void) openSelectedWithApp: (id) sender; {
    [self openSelected: sender];
}

- (void) openSelected: (id) sender; {
    if ([sender tag] == kAqMusic)
        [defaults setObject: [sender title] forKey: @"AcqMusicOpenWith"];
        
    if ([sender tag] == kAqVideo)
        [defaults setObject: [sender title] forKey: @"AcqVideoOpenWith"];
        
    if ([sender tag] == kAqImage)
        [defaults setObject: [sender title] forKey: @"AcqImageOpenWith"];
        
    if ([sender tag] == kAqDocument)
        [defaults setObject: [sender title] forKey: @"AcqTextOpenWith"];
    
    [self loadDefaults];
}

- (void) registerDefaults; {
    id dict = [[[NSMutableDictionary alloc] init] autorelease];

    [dict setObject: @"0" forKey: @"AcqMoveImages"];
    [dict setObject: @"0" forKey: @"AcqMoveVideos"];
    [dict setObject: @"0" forKey: @"AcqOpenFiles"];
    
    [dict setObject: DEFAULT forKey: @"AcqMusicOpenWith"];
    [dict setObject: DEFAULT forKey: @"AcqImageOpenWith"];
    [dict setObject: DEFAULT forKey: @"AcqVideoOpenWith"];
    [dict setObject: DEFAULT forKey: @"AcqTextOpenWith"];
        
    [defaults registerDefaults: dict];
}

- (void) loadDefaults; {
    tempBool = [defaults boolForKey: @"AcqMoveImages"];
    [moveImages setState: (tempBool) ? NSOnState : NSOffState];
    
    tempBool = [defaults boolForKey: @"AcqMoveVideos"];
    [moveVideos setState: (tempBool) ? NSOnState : NSOffState];
    
    tempBool = [defaults boolForKey: @"AcqOpenFiles"];
    [openFiles setState: (tempBool) ? NSOnState : NSOffState];
    
    tempString = [defaults objectForKey: @"AcqMusicOpenWith"];
    [openMusicPopup selectItemWithTitle: tempString];
    
    tempString = [defaults objectForKey: @"AcqImageOpenWith"];
    [openImagesPopup selectItemWithTitle: tempString];
    
    tempString = [defaults objectForKey: @"AcqVideoOpenWith"];
    [openVideosPopup selectItemWithTitle: tempString];
    
    tempString = [defaults objectForKey: @"AcqTextOpenWith"];
    [openTextPopup selectItemWithTitle: tempString];
}

- (IBAction) moveImages: (id) sender; {
    [defaults setBool: [sender intValue] forKey: @"AcqMoveImages"];
    [self loadDefaults];
}

- (IBAction) moveVideos: (id) sender; {
    [defaults setBool: [sender intValue] forKey: @"AcqMoveVideos"];
    [self loadDefaults];
}

- (IBAction) openFiles: (id) sender; {
    [defaults setBool: [sender intValue] forKey: @"AcqOpenFiles"];
    [self loadDefaults];
}

- (IBAction) openImagesPopup: (id) sender; {
    [defaults setObject: [sender title] forKey:@"AcqImageOpenWith"];
    [self loadDefaults];
}

- (IBAction) openVideosPopup: (id) sender; {
    [defaults setObject: [sender title] forKey:@"AcqVideoOpenWith"];
    [self loadDefaults];
}

- (IBAction) openMusicPopup: (id) sender; {
    [defaults setObject: [sender title] forKey:@"AcqMusicOpenWith"];
    [self loadDefaults];
}

- (IBAction) openTextPopup: (id) sender; {
    [defaults setObject: [sender title] forKey:@"AcqTextOpenWith"];
    [self loadDefaults];
}

@end
