/*
 ** AqStarCell
 ** 
 ** CHANGES:
 ** 0.21 (pozytron) New Image
 */

#import "AqRemoteFile.h"
#import "AqStarCell.h"
#import "DWCachedImage.h"
#import "DWColor.h"
#import "DWUtil.h"


@implementation AqStarCell

/* Initialization */
    
    static id gray[4] = {0,0,0,0};
    static id alpha[4] = {0,0,0,0};
    
    - (id) init; 
    {
        if (!gray[0]) 
        {
            id g = [NSImage imageNamed: @"AcqGrayStar"];
            
            int i,j;

            for (i=1; i<5; i++) {
                id image = [[[NSImage alloc] initWithSize: (NSSize){13*i, 13}] autorelease];
                [image lockFocus];
                for (j=0; j<i; j++) {
                    [g drawAtPoint: (NSPoint){13*j, 0} fromRect: NSZeroRect operation: NSCompositeSourceOver fraction: 1.0];
                }
                [image unlockFocus];
                gray[i-1] = [[DWCachedImage alloc] initWithImage: image];
            }

            for (i=1; i<5; i++) {
                id image = [[[NSImage alloc] initWithSize: (NSSize){13*i, 13}] autorelease];
                [image lockFocus];
                for (j=0; j<i; j++) {
                    [g drawAtPoint: (NSPoint){13*j, 0} fromRect: NSZeroRect operation: NSCompositeSourceOver fraction: 0.5];
                }
                [image unlockFocus];
                alpha[i-1] = [[DWCachedImage alloc] initWithImage: image];
            }
        }

        return [super init];
    }
    
    
/* Draw Interior Frame */

    - (void) drawInteriorWithFrame: (NSRect) frame inView: (NSView*) view; 
    {
        AqRemoteFile* obj = [self objectValue];
        int value = [obj rating]-1;
        if (value < 0 || value > 3) return;

        frame.origin.y += 2;
        frame.origin.x += 3;
        
        [([obj count] > 1) ? gray[value] : alpha[value] drawAtPoint: frame.origin withBackgroundColorIndex: dwColorIndex];
    }

@end