#import "AqProgressCell.h"
#import "AqUpload.h"
#import "NSImageExtensions.h"


@implementation AqProgressCell

    - (NSBezierPath*) roundedRectangleInRect: (NSRect) rect;
    {
        NSBezierPath* result = [[NSBezierPath alloc] init];

        /* set up points */
            
            float radius = rect.size.height / 2;
            
            NSPoint ul = NSMakePoint(rect.origin.x + radius, rect.origin.y + rect.size.height);
            NSPoint ml = NSMakePoint(rect.origin.x,          rect.origin.y + radius);
            NSPoint bl = NSMakePoint(rect.origin.x + radius, rect.origin.y);
            
            NSPoint ur = NSMakePoint(rect.origin.x + rect.size.width - radius, ul.y);
            NSPoint mr = NSMakePoint(rect.origin.x + rect.size.width , ml.y);
            NSPoint br = NSMakePoint(rect.origin.x + rect.size.width - radius, bl.y);
        
            float cpdelta = radius * 0.55;
        
            NSPoint ulcp1 = NSMakePoint(ul.x - cpdelta, ul.y);
            NSPoint ulcp2 = NSMakePoint(ml.x,           ml.y + cpdelta);
            NSPoint blcp1 = NSMakePoint(bl.x - cpdelta, bl.y);
            NSPoint blcp2 = NSMakePoint(ml.x,           ml.y - cpdelta);
    
            NSPoint brcp1 = NSMakePoint(br.x + cpdelta, br.y);
            NSPoint brcp2 = NSMakePoint(mr.x,           mr.y - cpdelta);
            NSPoint urcp1 = NSMakePoint(ur.x + cpdelta, ur.y);
            NSPoint urcp2 = NSMakePoint(mr.x,           mr.y + cpdelta);
        
        /* set up path */
            
            [result moveToPoint: ul];
            [result curveToPoint: ml controlPoint1: ulcp1 controlPoint2: ulcp2];
            [result curveToPoint: bl controlPoint1: blcp2 controlPoint2: blcp1];
            [result lineToPoint: br];
            [result curveToPoint: mr controlPoint1: brcp1 controlPoint2: brcp2];
            [result curveToPoint: ur controlPoint1: urcp2 controlPoint2: urcp1];
            [result lineToPoint: ul];

        return [result autorelease];
    }

    static NSImage* complete = nil;
    static NSImage* completegray = nil;
    static NSImage* verify = nil;
            
    - (void) drawInteriorWithFrame: (NSRect) frame inView: (NSView*) view; 
    {
        AqTransfer* t = [self objectValue];
        if (![t isKindOfClass: [AqTransfer class]]) return;
        
        if (!complete) {
            complete = [[NSImage imageNamed: @"AcqComplete"] retain];
            [complete setFlipped: YES];

            completegray = [[NSImage imageNamed: @"AcqCompleteGray"] retain];
            [completegray setFlipped: YES];

            verify = [[NSImage imageNamed: @"AcqFileVerify"] retain];
            [verify setFlipped: YES];

        }
        
        if (![t isActive])
        {
            NSPoint cPoint = frame.origin;
            cPoint.y += 11;
            cPoint.x += ((int)frame.size.width/2) - 7;
    
            if ([t isComplete] && ![t isCorrupt]) {
                [complete drawAtPoint: cPoint];
                return;
            } else if ([t isCorrupt]) {
                [completegray drawAtPoint: cPoint];
                return;
            } else if (t->state == 11) {
                [verify drawAtPoint: cPoint];
                return;
            } else {
                return;
            }
        }
        
        /* set up geometry */
        
            int topMargin  = 11;
            int leftMargin = 8;
            
            frame.origin.x   += leftMargin;
            frame.size.width -= leftMargin * 2;
    
            frame.origin.y    += topMargin;
            frame.origin.y    += 0.5;
            frame.size.height = 12;
            
            static NSBezierPath* rect = nil;
            if (!rect) {
                rect = [[self roundedRectangleInRect: NSMakeRect(0,0,frame.size.width,frame.size.height)] retain];
            }
            

        [[NSGraphicsContext currentContext] saveGraphicsState];
        
            id t2 = [NSAffineTransform transform];
            [t2 translateXBy: frame.origin.x yBy: frame.origin.y];
            [t2 concat];

        /* draw background & border */
        
            if (dwColorIndex == kDWColorAlternateIndex) {
                [[[NSColor whiteColor] colorWithAlphaComponent: 0.3] set];
            } else {
                [[NSColor whiteColor] set];
            }
            [rect fill];
                
            if (dwColorIndex == kDWColorAlternateIndex) {
                [[NSColor whiteColor] set];
            } else {
                [[NSColor grayColor] set];
            }
            [rect stroke];
        
        /* draw progress fill */
        
            float progress = t->amountTransferred->value / t->amountRequested->value;
            
            if (progress > 0) 
            {
                frame.size.width = (int)(frame.size.width * progress);
        
                [(dwColorIndex == kDWColorAlternateIndex) ? [NSColor whiteColor] : [NSColor lightGrayColor] set];
                
                [[NSGraphicsContext currentContext] saveGraphicsState];
        
                    [rect addClip];
                    NSRectFill((NSRect){{0,0}, {frame.size.width,frame.size.height}});
        
                [[NSGraphicsContext currentContext] restoreGraphicsState];
            }

        [[NSGraphicsContext currentContext] restoreGraphicsState];
    }
    
@end