#import "DWIconCache.h"
#import "AqIconCell.h"


@implementation AqIconCell

    - (id) init; {
        self = [super init];
        cache = [DWIconCache instance16];
        return self;
    }

    - (void) drawInteriorWithFrame: (NSRect) frame inView: (NSView*) view; 
    {
        id icon = [[cache iconForFilePath: (NSString*)[self objectValue]] originalImage];
        [icon setFlipped: YES];

        NSRect drawRect = {
            {frame.origin.x, frame.origin.y},
            {16,16}
        };
    
        [icon drawInRect: drawRect fromRect: NSZeroRect operation: NSCompositeSourceAtop fraction: 1.0];
    }

@end