#import "AqTableController.h"
#import "AqTableObject.h"
#import "NSMenuExtensions.h"


@implementation AqTableController

/* Browse Host */

    - (NSArray*) arrayByRemovingDuplicatesFromArray: (id) theArray; {
        NSMutableArray* result = [[[NSMutableArray alloc] init] autorelease];
        int i, count = [theArray count];
        for (i=0; i<count; i++) {
            id obj = [theArray objectAtIndex: i];
            if (![result containsObject: obj] && ![@"" isEqual: obj]) {
                [result addObject: obj];
            }
        }
        return result;
    }
    
    - (NSArray*) selectedBrowseableHosts; {
        NSMutableArray* result = [[[NSMutableArray alloc] init] autorelease];
        id objs = [self selectedObjects];
        int i, count = [objs count];
        for (i=0; i<count; i++) {
            [result addObjectsFromArray: [[objs objectAtIndex: i] browseableHosts]];
        }
        return [self arrayByRemovingDuplicatesFromArray: result];
    }

    - (BOOL) canBrowseSelection; {
        return [[self selectedBrowseableHosts] count];
    }

@end