/*
** AqMediaType
** 
** CHANGES:
** 0.23 (pozytron) Added "isImage," "isVideo" and "isDocument" utility methods
*/

#import "AqMediaType.h"


AqMediaType AqMediaTypeForExtension(id theExtension)
{
    static NSSet* music = nil;
    static NSSet* video = nil;
    static NSSet* image = nil;
    static NSSet* document = nil;

    if (!music) {
        music = [[NSSet alloc] initWithObjects: @"mp3", @"ogg", @"wma", @"aiff", @"aif", @"au", @"mod", @"wav", @"mid", @"m4a", nil];
        video = [[NSSet alloc] initWithObjects: @"mp4", @"avi", @"mov", @"mpg", @"mpeg", @"asf", @"rm", @"ram", @"divx", @"wmv", nil];
        image = [[NSSet alloc] initWithObjects: @"gif", @"jpg", @"jpe", @"jpeg", @"png", @"tif", @"tiff", @"bmp", nil];
        document = [[NSSet alloc] initWithObjects: @"doc", @"pdf", @"rtf", @"rtfd", @"txt", @"htm", @"html", nil];
    }
    
    if ([music member: theExtension]) return kAqMusic;
    if ([video member: theExtension]) return kAqVideo;
    if ([image member: theExtension]) return kAqImage;
    if ([document member: theExtension]) return kAqDocument;
    return kAqFile;
}

BOOL isMusic(id theExtension) {
    return AqMediaTypeForExtension(theExtension) == kAqMusic;
}

BOOL isImage(id theExtension) {
    return AqMediaTypeForExtension(theExtension) == kAqImage;
}

BOOL isVideo(id theExtension) {
    return AqMediaTypeForExtension(theExtension) == kAqVideo;
}

BOOL isDocument(id theExtension) {
    return AqMediaTypeForExtension(theExtension) == kAqDocument;
}