#import "AqCore(Dispatch).h"
#import "AqDownloadsController.h"
#import "AqLibraryController.h"
#import "AqNetworkController.h"
#import "AqUploadsController.h"


@implementation AqCoreController (Dispatch)
    
    - (void) dispatchCommand: (id) frags;
    {
        

        NS_DURING

        switch([[frags objectAtIndex: 0] intValue])
        {

        /* Connections */

            case 1: /* ConnectionInitialized */
                [[AqNetworkController instance] connectionInitialized: frags];
                break;
                
            case 2: /* ConnectionClosed */
                [[AqNetworkController instance] connectionClosed: frags];
                break;
        
            case 3: /* UpdateConnectionStats */
                [[AqNetworkController instance] updateConnectionStats: frags];
                break;

            case 14: /* ConnectionsUpdated */
                [[AqNetworkController instance] statsUpdated];
                break;
        
        /* Queries */
                
            case 5: /* QueryReply */
                [AqQC handleQueryReply: frags];
                break;
    
        /* Uploads */

            case 6: /* AddUpload */
                [[AqUploadsController instance] addUpload: frags];
                break;
                
            case 7: /* RemoveUpload */
                [[AqUploadsController instance] removeUpload: frags];
                break;

            case 8: /* UpdateUploadStats */
                [[AqUploadsController instance] updateUploadStats: frags];
                break;

            case 12: /* UploadsUpdated */
                [[AqUploadsController instance] statsUpdated];
                break;

        /* Downloads */
        
            case 9: /* AddDownload */
                [[AqDownloadsController instance] addDownload: frags];
                break;
            
            case 10: /* RemoveDownload */
                [[AqDownloadsController instance] removeDownload: frags];
                break; 
            
            case 11: /* UpdateDownloadStats */
                [[AqDownloadsController instance] updateDownloadStats: frags];
                //NSLog(@"%@", frags);
                break;

            case 13: /* DownloadsUpdated */
                [[AqDownloadsController instance] statsUpdated];
                break;
        
        /* Sharing */
        
            case 15: /* AddSharedFile */
                [[AqLibraryController instance] addSharedFile: frags];
                break;
            
            case 16: /* AddSharedDirectory */
                break;
        
            default:
                NSLog(@"dataAvailable: %@", frags);
                break;
        }
        
        NS_HANDLER
            
            NSLog(@"%@", localException);
            NSLog(@"***** EXCEPTION *****: %@\n", frags);
        
        NS_ENDHANDLER
    }

@end