/*
 * Acquisition
 * http://www.xlife.org/
 *
 * Copyright (c) 2002-2003 David Keiichi Watanabe
 * davew@xlife.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* Java */
import java.io.*;
import java.util.*;

/* LimeWire */
import com.limegroup.gnutella.*;
import com.limegroup.gnutella.downloader.*;
import com.limegroup.gnutella.messages.*;
import com.limegroup.gnutella.search.*;
import com.limegroup.gnutella.security.*;
import com.limegroup.gnutella.xml.*;


public class AqEventHandler implements ActivityCallback
{
    
/* Instances */
    
    public static Vector responses = new Vector();
    public static Vector downloads = new Vector();
    public static Vector queries   = new Vector();
    public static Map    hosts     = new HashMap();
    public static Vector connections = new Vector();
            

/* Callbacks */
    
    /* Connections */
        
        public void connectionInitializing(Connection c) 
        {
            if (c.getIPString().equals("0.0.0.0")) {
                c.close();
                return;
            }
        }

        public void connectionInitialized(Connection c1) 
        {
            ManagedConnection c = (ManagedConnection)c1;

            if (c.getIPString().equals("0.0.0.0")) {
                c.close();
                return;
            }
            
            if (c.getUserAgent() == null) {
                c.close();
                return;
            }
            
            String u = c.getUserAgent();
            if (u == null) {
                return;
            }

	    /*
            if (u.startsWith("Gnutella") || u.startsWith("Morpheus") || u.startsWith("Gnucleus") || u.startsWith("BearShare")) {
                c.close();
                return;
            }
	    */

            if (c.isTempConnection()) {
                return;
            }
            
            /*
            if (c.isOutgoing()) {
                System.err.println("outgoing: " + c);
            } else {
                System.err.println("incoming: " + c);
            }
            */
            
            connections.add(c);
            AqEvent.signalEvent(AqEvent.kLWEventConnectionInitialized, c);
        }

        public void connectionClosed(Connection c) {
            if (connections.contains(c)) {
                AqEvent.signalEvent(AqEvent.kLWEventConnectionClosed, c);
                connections.remove(c);
            }
        }

        public void knownHost(Endpoint e) {
            /* this is never called */
        }

    /* Queries */
   
        public void handleQueryResult(RemoteFileDesc r, HostData d)
        {
            String ip = d.getIP();
            String name = r.getFileName();

            //System.err.println("handleQueryResult: bad IP: " + ip);

            if (ip.startsWith("0") /* || ip.startsWith("192.168") || ip.startsWith("10") || ip.startsWith("172") || ip.startsWith("38.144.198")*/) {
                ///System.err.println("handleQueryResult: bad IP: " + ip);
                //System.err.println(r.getPushProxies());
                //return;
                /*
                if (r.getPushProxies().size() == 0) {
                    RemoteFileDesc files[] = new RemoteFileDesc[1];
                    files[0] = r;
                    try {
                        RouterService.download(files, true);
                    } catch (Exception e) {}
                }
                */
                return;
            }

            if (d.getQuality() < 0) {
                //System.err.println("handleQueryResult: negative quality");
                return;
            }

            if (r.getSize() == 0) {
                //System.err.println("handleQueryResult: zero size");
                return;
            }

            if (name.startsWith("!") || name.startsWith("._") || name.startsWith("_")) {
                //System.err.println("handleQueryResult: bad name: " + name);
                return;
            }
            
            AqEvent.signalEvent(AqEvent.kLWEventQueryResult, r, d);
        }

        public void handleQueryString(String query) {
        }

    /* Downloads */

        public void addDownload(Downloader d) 
        {
            //System.err.println("addDownload: " + d);

            downloads.add(d);
            AqEvent.signalEvent(AqEvent.kLWEventAddDownload, d);
        }
    
        public void removeDownload(Downloader d) 
        {
            //System.err.println("removeDownload: " + d);

            AqEvent.signalEvent(AqEvent.kLWEventUpdateDownloadStats, d);
            AqEvent.signalEvent(AqEvent.kLWEventRemoveDownload, d);
        }

        public void downloadsComplete() {
        }

    /* Uploads */
    
        public void addUpload(Uploader u) {
            int s = u.getState();
            /* this appears to be done already internally
            if (u.getUserAgent() != null && u.getUserAgent().startsWith("Morpheus")) {
                System.err.println("blocking upload to: " + u.getUserAgent());
                u.stop();
                return;
            }
            */
            if (s != Uploader.LIMIT_REACHED && s != Uploader.COMPLETE && s != Uploader.FILE_NOT_FOUND) {
                AqEvent.signalEvent(AqEvent.kLWEventAddUpload, u);
            }
        }
    
        public void removeUpload(Uploader u) {
            AqEvent.signalEvent(AqEvent.kLWEventRemoveUpload, u);
        }
        
        public void uploaderStateChanged(Uploader u) {
            //System.err.println("uploaderStateChange: " + u + " " + u.getState());
            AqEvent.signalEvent(AqEvent.kLWEventUpdateUploadStats, u);
        }

        public void uploadsComplete() {
        }
    
    /* Browse */

        public void browseHostFailed(GUID guid) {
            System.err.println("browseHostFailed: " + guid);
        }
    
    /* Sharing */
    
        public void addSharedDirectory(final File f, final File parent) {
            //AqEvent.signalEvent(kLWEventAddSharedDirectory, f);
        }

        public void addSharedFile(final FileDesc f, final File parent) {
            //AqEvent.signalEvent(AqEvent.kLWEventAddSharedFile, f);
        }

        public void handleSharedFileUpdate(File f) {
            //System.err.println("handleSharedFileUpdate: " + f);
        }

	public void clearSharedFiles() {
            //System.err.println("clearSharedFiles");
        }
    
    /* Misc */

        public void fileManagerLoaded() {
        }

	public void restoreApplication() {
        }
        
	public void showDownloads() {
        }

        public User getUserAuthenticationInfo(String host) {
            return null;
        }

        public void promptAboutCorruptDownload(Downloader dloader) {
            dloader.discardCorruptDownload(true);
        }

        public void setAnnotateEnabled(boolean enabled) {
        }
    
        public String getHostValue(String key) {
            return null;
        }
}