/*
 * Acquisition
 * http://www.xlife.org/
 *
 * Copyright (c) 2002-2003 David Keiichi Watanabe
 * davew@xlife.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * (AcqLite 0.11) FilterUnf Setting Added
 */

/* LimeWire */
import com.limegroup.gnutella.*;
import com.limegroup.gnutella.browser.*;
import com.limegroup.gnutella.downloader.*;
import com.limegroup.gnutella.settings.*;
import com.limegroup.gnutella.util.*;

/* Java */
import java.io.*;
import java.util.*;


public class AqDispatcher 
{
    public static void dispatchCommand(Vector v) throws Exception
    {
        String command = (String)v.elementAt(0);

        /* Magnet URLs */
        
            if (command.equals("handleMagnet"))
            {
                System.err.println(v);
                ExternalControl.handleMagnetRequest((String)v.elementAt(1));
            }
        
        /* Ultrapeers */
            
            if (command.equals("setEnableUltrapeer"))
            {	
                int value = new Integer((String)v.elementAt(1)).intValue();
                System.err.println(v);
                UltrapeerSettings.DISABLE_ULTRAPEER_MODE.setValue(value == 0);
                return;
            }

            
            /*
            if (command.equals("setForceUltrapeer"))
            {
                int value = new Integer((String)v.elementAt(1)).intValue();
                System.err.println(v);
                UltrapeerSettings.FORCE_ULTRAPEER_MODE.setValue(value == 1);
                if (value == 1)
                    UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.setValue(true);
                return;
            }
            */
            
        /* Filter Non-LimeWire clients (AcqLite 0.11) */
            
            if (command.equals("setFilterUnf"))
            {	
                int value = new Integer((String)v.elementAt(1)).intValue();
                System.err.println(v);
                ConnectionSettings.FILTER_UNF.setValue(value == 1);
                return;
            }
            
        /* Query */

            if (command.equals("query"))
            {
                String queryString = (String)v.elementAt(1);
                
                System.err.println(v);

                GUID guid = new GUID(RouterService.queryWithString2(queryString));
                AqEventHandler.queries.add(guid.toString());
                return;
            }
            
        /* Downloads */
            
            if (command.equals("download"))
            {
                RemoteFileDesc files[] = new RemoteFileDesc[v.size()-1];
                String name = null;
                for (int i=1; i<v.size(); i++) {	
                    files[i-1] = (RemoteFileDesc)AqEventHandler.responses.elementAt(new Integer((String)v.elementAt(i)).intValue());
                    if (name == null) {
                        name = files[i-1].getFileName();
                    }
                }
                
                //System.err.println("dispatchCommand: download: " + files.length);
                try {
                    RouterService.download(files, true);
                } catch (AlreadyDownloadingException e) {
                }
                
                /*
                RemoteFileDesc files[] = new RemoteFileDesc[1];
                files[0] = (RemoteFileDesc)AqEventHandler.responses.elementAt(new Integer((String)v.elementAt(1)).intValue());
                
                System.err.println(v);
                System.err.println("dispatchCommand: download: " + files.length);
                ManagedDownloader d = (ManagedDownloader)RouterService.download(files, true);

                for (int i=2; i<v.size(); i++) {
                    d.addDownloadForced((RemoteFileDesc)AqEventHandler.responses.elementAt(new Integer((String)v.elementAt(i)).intValue()), true);
                }
                */

                return;
            }
            
            if (command.equals("retryDownload"))
            {
                System.err.println(v);
            
                int index = new Integer((String)v.elementAt(1)).intValue();
                Downloader d = (Downloader)AqEventHandler.downloads.get(index);
                d.resume();
                return;
            }

            if (command.equals("requeryDownload"))
            {
                System.err.println(v);
            
                int index = new Integer((String)v.elementAt(1)).intValue();
                ManagedDownloader d = (ManagedDownloader)AqEventHandler.downloads.get(index);
                d.sendRequery();
                return;
            }

            if (command.equals("cancelDownload"))
            {
                int index = new Integer((String)v.elementAt(1)).intValue();
                Downloader d = (Downloader)AqEventHandler.downloads.get(index);
                d.stop();
                return;
            }
            
        /* Uploads */
        
            if (command.equals("cancelUpload"))
            {
                Iterator i = RouterService.getUploadManager().getUploads().iterator();
                while (i.hasNext()) {
                    Uploader u = (Uploader)i.next();
                    if (u.getHost().equals(v.elementAt(1)) && u.getFileName().equals(v.elementAt(2)))
                        u.stop();
                }
                return;
            }

            if (command.equals("setMaxUploads")) 
            {
                int value = new Integer((String)v.elementAt(1)).intValue();
                UploadSettings.MAX_UPLOADS.setValue(value);
                return;
            }

            if (command.equals("setUploadsPerPerson")) 
            {
                int value = new Integer((String)v.elementAt(1)).intValue();
                UploadSettings.UPLOADS_PER_PERSON.setValue(value);
                return;
            }
            
            if (command.equals("setUploadSpeed"))
            {
                int value = new Integer((String)v.elementAt(1)).intValue();
                UploadSettings.UPLOAD_SPEED.setValue(value);
                return;
            }

        /* 'closeConnection' */
        
            if (command.equals("closeConnection")) 
            {
                String host = (String)v.elementAt(1);
    
                Iterator i = RouterService.getConnectionManager().getConnections().iterator();
                while (i.hasNext()) {
                    Connection c = (Connection)i.next();
                    if (c.getIPString().equals(host)) {
                        c.close();
                    }
                }
                return;
            }
            
        /* 'setKeepAlive' */
        
            if (command.equals("setKeepAlive")) 
            {
                int value = new Integer((String)v.elementAt(1)).intValue();
                //if (RouterService.getConnectionManager().getKeepAlive() != 32)
                if (RouterService.getConnectionManager().getKeepAlive() != value)
                    RouterService.getConnectionManager().setKeepAlive(value);
                return;
            }
            
        /* 'setConnectionSpeed' */

            if (command.equals("setConnectionSpeed")) 
            {
                int value = new Integer((String)v.elementAt(1)).intValue();
                ConnectionSettings.CONNECTION_SPEED.setValue(value);
                return;
            }
        
        /* 'setPort' */

            if (command.equals("setPort")) 
            {
                int value = new Integer((String)v.elementAt(1)).intValue();
                ConnectionSettings.PORT.setValue(value);
                RouterService.setListeningPort(value);
                return;
            }

        /* 'doBrowseHost' */

            if (command.equals("doBrowseHost")) 
            {
                final String host = (String)v.elementAt(1);
                final int port = new Integer((String)v.elementAt(2)).intValue();

                final GUID serventID = (GUID)AqEventHandler.hosts.get(host + port);
                final GUID queryGUID = new GUID(RouterService.newQueryGUID());
                
                AqEventHandler.queries.add(queryGUID.toString());

                new Thread() {
                    public void run() {
                        RouterService.doBrowseHost(host, port, queryGUID, serventID, null);
                    }
                }.start();

                return;
            }

        /* Directories */

            if (command.equals("setDirectories")) 
            {   
                SharingSettings.setDirectoriesWithString((String)v.elementAt(1));
                System.err.println(v);
                RouterService.getFileManager().loadSettings(false);
                return;
            }

            if (command.equals("setSaveDirectory")) 
            {
                String value = (String)v.elementAt(1);
                SharingSettings.DIRECTORY_FOR_SAVING_FILES.setValue(new File(value));
                SharingSettings.INCOMPLETE_DIRECTORY.setValue(new File(SharingSettings.DIRECTORY_FOR_SAVING_FILES.getValue(), "Incomplete"));
                return;
            }

            if (command.equals("setIncompleteDirectory")) 
            {
                String value = (String)v.elementAt(1);
                SharingSettings.INCOMPLETE_DIRECTORY.setValue(new File(value));
                return;
            }
        
        /* 'setMaxSimDownload' */
        
            if (command.equals("setMaxSimDownload")) 
            {
                int value = new Integer((String)v.elementAt(1)).intValue();
                DownloadSettings.MAX_SIM_DOWNLOAD.setValue(value);
                return;
            }
    }
}